/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class PrepareMergeOperation
extends AbstractClusterOperation {
    private Address newTargetAddress;

    public PrepareMergeOperation() {
    }

    public PrepareMergeOperation(Address newTargetAddress) {
        this.newTargetAddress = newTargetAddress;
    }

    @Override
    public void run() {
        boolean local;
        Address caller = this.getCallerAddress();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        Address masterAddress = node.getMasterAddress();
        ILogger logger2 = node.loggingService.getLogger(this.getClass().getName());
        boolean bl = local = caller == null;
        if (!local && !caller.equals(masterAddress)) {
            logger2.warning("Prepare-merge instruction sent from non-master endpoint: " + caller);
            return;
        }
        logger2.warning("Preparing to merge... Waiting for merge instruction...");
        node.getClusterService().prepareToMerge(this.newTargetAddress);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newTargetAddress = new Address();
        this.newTargetAddress.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.newTargetAddress.writeData(out);
    }
}

