/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntryEventImpl;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.HashSet;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

public class CacheEventListenerAdaptor<K, V>
implements CacheEventListener {
    private final CacheEntryCreatedListener cacheEntryCreatedListener;
    private final CacheEntryRemovedListener cacheEntryRemovedListener;
    private final CacheEntryUpdatedListener cacheEntryUpdatedListener;
    private final CacheEntryExpiredListener cacheEntryExpiredListener;
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private final boolean isOldValueRequired;
    private SerializationService serializationService;
    private transient ICache<K, V> source;

    public CacheEventListenerAdaptor(ICache<K, V> source, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, SerializationService serializationService) {
        this.source = source;
        this.serializationService = serializationService;
        CacheEntryListener<K, V> cacheEntryListener = cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create();
        this.cacheEntryCreatedListener = cacheEntryListener instanceof CacheEntryCreatedListener ? (CacheEntryCreatedListener)cacheEntryListener : null;
        this.cacheEntryRemovedListener = cacheEntryListener instanceof CacheEntryRemovedListener ? (CacheEntryRemovedListener)cacheEntryListener : null;
        this.cacheEntryUpdatedListener = cacheEntryListener instanceof CacheEntryUpdatedListener ? (CacheEntryUpdatedListener)cacheEntryListener : null;
        this.cacheEntryExpiredListener = cacheEntryListener instanceof CacheEntryExpiredListener ? (CacheEntryExpiredListener)cacheEntryListener : null;
        Factory<CacheEntryEventFilter<K, V>> filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        this.filter = filterFactory != null ? filterFactory.create() : null;
        this.isOldValueRequired = cacheEntryListenerConfiguration.isOldValueRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(Object eventObject) {
        if (eventObject instanceof CacheEventSet) {
            CacheEventSet cacheEventSet = (CacheEventSet)eventObject;
            try {
                if (cacheEventSet.getEventType() != CacheEventType.COMPLETED) {
                    this.handleEvent(cacheEventSet);
                }
            }
            finally {
                ((CacheSyncListenerCompleter)((Object)this.source)).countDownCompletionLatch(cacheEventSet.getCompletionId());
            }
        }
    }

    private void handleEvent(CacheEventSet cacheEventSet) {
        Iterable cacheEntryEvent = this.createCacheEntryEvent(cacheEventSet);
        switch (cacheEventSet.getEventType()) {
            case CREATED: {
                if (this.cacheEntryCreatedListener == null) break;
                this.cacheEntryCreatedListener.onCreated(cacheEntryEvent);
                break;
            }
            case UPDATED: {
                if (this.cacheEntryUpdatedListener == null) break;
                this.cacheEntryUpdatedListener.onUpdated(cacheEntryEvent);
                break;
            }
            case REMOVED: {
                if (this.cacheEntryRemovedListener == null) break;
                this.cacheEntryRemovedListener.onRemoved(cacheEntryEvent);
                break;
            }
            case EXPIRED: {
                if (this.cacheEntryExpiredListener == null) break;
                this.cacheEntryExpiredListener.onExpired(cacheEntryEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + cacheEventSet.getEventType().name());
            }
        }
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> createCacheEntryEvent(CacheEventSet cacheEventSet) {
        HashSet<CacheEntryEvent<K, V>> evt = new HashSet<CacheEntryEvent<K, V>>();
        for (CacheEventData cacheEventData : cacheEventSet.getEvents()) {
            EventType eventType = CacheEventType.convertToEventType(cacheEventData.getCacheEventType());
            Object key = this.toObject(cacheEventData.getDataKey());
            Object newValue = this.toObject(cacheEventData.getDataValue());
            Object oldValue = this.isOldValueRequired ? (Object)this.toObject(cacheEventData.getDataOldValue()) : null;
            CacheEntryEventImpl<K, Object> event = new CacheEntryEventImpl<K, Object>(this.source, eventType, key, newValue, oldValue);
            if (this.filter != null && !this.filter.evaluate(event)) continue;
            evt.add(event);
        }
        return evt;
    }

    private <T> T toObject(Data data) {
        return this.serializationService.toObject(data);
    }
}

