/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.impl.NoClassDefFoundDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 4);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    Object writeReplace() {
        this._incompleteDeserializers.clear();
        return this;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType propertyType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser == null && (deser = this._createAndCacheValueDeserializer(ctxt, factory, propertyType)) == null) {
            deser = this._handleUnknownValueDeserializer(propertyType);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        KeyDeserializer kd = factory.createKeyDeserializer(ctxt, type2);
        if (kd == null) {
            return this._handleUnknownKeyDeserializer(type2);
        }
        if (kd instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)kd)).resolve(ctxt);
        }
        return kd;
    }

    public boolean hasValueDeserializerFor(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type2);
        if (deser == null) {
            deser = this._createAndCacheValueDeserializer(ctxt, factory, type2);
        }
        return deser != null;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        return this._cachedDeserializers.get(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> deser = this._findCachedDeserializer(type2);
                if (deser != null) {
                    return deser;
                }
                int count = this._incompleteDeserializers.size();
                if (count > 0 && (deser = this._incompleteDeserializers.get(type2)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(ctxt, factory, type2);
                    if (count != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (count == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(ctxt, factory, type2);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser == null) {
            return null;
        }
        boolean isResolvable = deser instanceof ResolvableDeserializer;
        boolean addToCache = deser.isCachable();
        if (isResolvable) {
            this._incompleteDeserializers.put(type2, deser);
            ((ResolvableDeserializer)((Object)deser)).resolve(ctxt);
            this._incompleteDeserializers.remove(type2);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type2, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        Class<?> builder;
        Object beanDesc;
        DeserializationConfig config = ctxt.getConfig();
        if (type2.isAbstract() || type2.isMapLikeType() || type2.isCollectionLikeType()) {
            type2 = factory.mapAbstractType(config, type2);
        }
        try {
            beanDesc = config.introspect(type2);
        }
        catch (NoClassDefFoundError error) {
            return new NoClassDefFoundDeserializer<Object>(error);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(ctxt, ((BeanDescription)beanDesc).getClassInfo());
        if (deser != null) {
            return deser;
        }
        JavaType newType = this.modifyTypeByAnnotation(ctxt, ((BeanDescription)beanDesc).getClassInfo(), type2);
        if (newType != type2) {
            type2 = newType;
            beanDesc = config.introspect(newType);
        }
        if ((builder = ((BeanDescription)beanDesc).findPOJOBuilder()) != null) {
            return factory.createBuilderBasedDeserializer(ctxt, type2, (BeanDescription)beanDesc, builder);
        }
        Converter<Object, Object> conv = ((BeanDescription)beanDesc).findDeserializationConverter();
        if (conv == null) {
            return this._createDeserializer2(ctxt, factory, type2, (BeanDescription)beanDesc);
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        if (!delegateType.hasRawClass(type2.getRawClass())) {
            beanDesc = config.introspect(delegateType);
        }
        return new StdDelegatingDeserializer<Object>(conv, delegateType, this._createDeserializer2(ctxt, factory, delegateType, (BeanDescription)beanDesc));
    }

    protected JsonDeserializer<?> _createDeserializer2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2, BeanDescription beanDesc) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        if (type2.isEnumType()) {
            return factory.createEnumDeserializer(ctxt, type2, beanDesc);
        }
        if (type2.isContainerType()) {
            JsonFormat.Value format;
            if (type2.isArrayType()) {
                return factory.createArrayDeserializer(ctxt, (ArrayType)type2, beanDesc);
            }
            if (type2.isMapLikeType()) {
                MapLikeType mlt = (MapLikeType)type2;
                if (mlt.isTrueMapType()) {
                    return factory.createMapDeserializer(ctxt, (MapType)mlt, beanDesc);
                }
                return factory.createMapLikeDeserializer(ctxt, mlt, beanDesc);
            }
            if (type2.isCollectionLikeType() && ((format = beanDesc.findExpectedFormat(null)) == null || format.getShape() != JsonFormat.Shape.OBJECT)) {
                CollectionLikeType clt = (CollectionLikeType)type2;
                if (clt.isTrueCollectionType()) {
                    return factory.createCollectionDeserializer(ctxt, (CollectionType)clt, beanDesc);
                }
                return factory.createCollectionLikeDeserializer(ctxt, clt, beanDesc);
            }
        }
        if (JsonNode.class.isAssignableFrom(type2.getRawClass())) {
            return factory.createTreeDeserializer(config, type2, beanDesc);
        }
        return factory.createBeanDeserializer(ctxt, type2, beanDesc);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        JsonDeserializer<Object> deser = ctxt.deserializerInstance(ann, deserDef);
        return this.findConvertingDeserializer(ctxt, ann, deser);
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext ctxt, Annotated a, JsonDeserializer<Object> deser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(ctxt, a);
        if (conv == null) {
            return deser;
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        return new StdDelegatingDeserializer<Object>(conv, delegateType, deser);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext ctxt, Annotated a) throws JsonMappingException {
        Object convDef = ctxt.getAnnotationIntrospector().findDeserializationConverter(a);
        if (convDef == null) {
            return null;
        }
        return ctxt.converterInstance(a, convDef);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext ctxt, Annotated a, JavaType type2) throws JsonMappingException {
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, type2);
        if (subclass != null) {
            try {
                type2 = type2.narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type2 + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (type2.isContainerType()) {
            Object cdDef;
            JavaType contentType;
            Class<?> cc;
            KeyDeserializer kd;
            Object kdDef;
            JavaType keyType;
            Class<?> keyClass = intr.findDeserializationKeyType(a, type2.getKeyType());
            if (keyClass != null) {
                if (!(type2 instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type2 + " is not a Map(-like) type");
                }
                try {
                    type2 = ((MapLikeType)type2).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type2 + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((keyType = type2.getKeyType()) != null && keyType.getValueHandler() == null && (kdDef = intr.findKeyDeserializer(a)) != null && (kd = ctxt.keyDeserializerInstance(a, kdDef)) != null) {
                type2 = ((MapLikeType)type2).withKeyValueHandler(kd);
                keyType = type2.getKeyType();
            }
            if ((cc = intr.findDeserializationContentType(a, type2.getContentType())) != null) {
                try {
                    type2 = type2.narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type2 + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((contentType = type2.getContentType()).getValueHandler() == null && (cdDef = intr.findContentDeserializer(a)) != null) {
                JsonDeserializer<Object> cd = null;
                if (cdDef instanceof JsonDeserializer) {
                    cdDef = (JsonDeserializer)cdDef;
                } else {
                    Class<?> cdClass = this._verifyAsClass(cdDef, "findContentDeserializer", JsonDeserializer.None.class);
                    if (cdClass != null) {
                        cd = ctxt.deserializerInstance(a, cdClass);
                    }
                }
                if (cd != null) {
                    type2 = type2.withContentValueHandler(cd);
                }
            }
        }
        return type2;
    }

    private Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type2) throws JsonMappingException {
        Class<?> rawClass = type2.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type2);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type2);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type2) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type2);
    }
}

