/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.requesttracing;

import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class RequestTrace
implements Serializable,
Comparable<RequestTrace> {
    private static final Logger LOGGER = Logger.getLogger(RequestTrace.class.getName());
    private boolean started;
    private boolean completed;
    private Instant startTime;
    private Instant endTime;
    private long elapsedTime;
    private final LinkedList<RequestTraceSpan> trace = new LinkedList();
    private final List<RequestTraceSpanLog> spanLogs = new LinkedList<RequestTraceSpanLog>();

    public void addEvent(RequestTraceSpan span) {
        if (this.completed && span.getEventType() != EventType.TRACE_START && span.getEventType() != EventType.PROPAGATED_TRACE) {
            return;
        }
        if (null != span.getEventType()) {
            switch (span.getEventType()) {
                case TRACE_START: {
                    this.handleTraceStart(span);
                    break;
                }
                case PROPAGATED_TRACE: {
                    this.handlePropagatedTrace(span);
                    break;
                }
                case REQUEST_EVENT: {
                    this.handleRequestEvent(span);
                    break;
                }
            }
        }
    }

    public void addEvent(RequestTraceSpan span, long timestampMillis) {
        if (this.completed && span.getEventType() != EventType.TRACE_START && span.getEventType() != EventType.PROPAGATED_TRACE) {
            return;
        }
        if (null != span.getEventType()) {
            switch (span.getEventType()) {
                case TRACE_START: {
                    this.handleTraceStart(span);
                    break;
                }
                case PROPAGATED_TRACE: {
                    this.handlePropagatedTrace(span);
                    break;
                }
                case REQUEST_EVENT: {
                    this.handleRequestEvent(span, timestampMillis);
                    break;
                }
            }
        }
    }

    private void handleTraceStart(RequestTraceSpan span) {
        this.trace.clear();
        this.startTime = span.getStartInstant();
        this.trace.add(span);
        this.started = true;
        this.completed = false;
    }

    private void handlePropagatedTrace(RequestTraceSpan span) {
        this.trace.clear();
        this.startTime = span.getStartInstant();
        this.trace.add(span);
        this.started = true;
        this.completed = false;
    }

    private void handleRequestEvent(RequestTraceSpan span) {
        if (!this.started) {
            return;
        }
        RequestTraceSpan rootSpan = this.trace.getFirst();
        span.setTraceId(rootSpan.getTraceId());
        span.setSpanDuration(span.getStartInstant().until(Instant.now(), ChronoUnit.NANOS));
        span.setTraceEndTime(Instant.now());
        this.trace.add(span);
    }

    private void handleRequestEvent(RequestTraceSpan span, long timestampMillis) {
        if (!this.started) {
            return;
        }
        RequestTraceSpan rootSpan = this.trace.getFirst();
        span.setTraceId(rootSpan.getTraceId());
        span.setSpanDuration(span.getStartInstant().until(Instant.ofEpochMilli(timestampMillis), ChronoUnit.NANOS));
        span.setTraceEndTime(Instant.ofEpochMilli(timestampMillis));
        this.trace.add(span);
    }

    public void endTrace() {
        this.endTrace(Instant.now().toEpochMilli());
    }

    public void endTrace(long timestampMillis) {
        if (!this.started) {
            return;
        }
        Collections.sort(this.trace);
        RequestTraceSpan startSpan = this.trace.getFirst();
        this.endTime = Instant.ofEpochMilli(timestampMillis);
        startSpan.setSpanDuration(this.startTime.until(this.endTime, ChronoUnit.NANOS));
        startSpan.setTraceEndTime(this.endTime);
        this.elapsedTime = TimeUnit.MILLISECONDS.convert(startSpan.getSpanDuration(), TimeUnit.NANOSECONDS);
        this.completed = true;
        this.assignLogs();
        this.assignReferences();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\"traceSpans\":[");
        for (RequestTraceSpan span : this.trace) {
            sb.append(span.toString());
            if (this.trace.indexOf(span) == this.trace.size() - 1) continue;
            sb.append(",");
        }
        sb.append("\n]}");
        return sb.toString();
    }

    public boolean isStarted() {
        return this.started;
    }

    public LinkedList<RequestTraceSpan> getTraceSpans() {
        return this.trace;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public UUID getTraceId() {
        UUID result = null;
        RequestTraceSpan re = this.trace.getFirst();
        if (re != null) {
            result = re.getTraceId();
        }
        return result;
    }

    public void setTraceId(UUID newID) {
        for (RequestTraceSpan span : this.trace) {
            span.setTraceId(newID);
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void addSpanLog(RequestTraceSpanLog spanLog) {
        this.spanLogs.add(spanLog);
    }

    private void assignLogs() {
        block0: for (RequestTraceSpanLog spanLog : this.spanLogs) {
            ListIterator<RequestTraceSpan> iterator = this.trace.listIterator(this.trace.size());
            while (iterator.hasPrevious()) {
                RequestTraceSpan span = iterator.previous();
                if (spanLog.getTimeMillis() <= span.getTimeOccured() || spanLog.getTimeMillis() >= span.getTraceEndTime().toEpochMilli()) continue;
                span.addSpanLog(spanLog);
                continue block0;
            }
        }
    }

    private void assignReferences() {
        boolean root = true;
        for (RequestTraceSpan span : this.trace) {
            if (root) {
                root = false;
                continue;
            }
            RequestTraceSpan bestMatchingParent = null;
            if (span.getTraceEndTime() == null) {
                LOGGER.info(() -> this.logUnfinishedSpan(span));
                span.setTraceEndTime(this.trace.getFirst().getTraceEndTime());
                continue;
            }
            for (RequestTraceSpan comparisonSpan : this.trace) {
                if (comparisonSpan.getTraceEndTime() == null || span == comparisonSpan || span.getTimeOccured() <= comparisonSpan.getTimeOccured() || span.getTraceEndTime().compareTo(comparisonSpan.getTraceEndTime()) >= 0) continue;
                if (bestMatchingParent == null) {
                    bestMatchingParent = comparisonSpan;
                    continue;
                }
                if (bestMatchingParent.getTimeOccured() >= comparisonSpan.getTimeOccured()) continue;
                bestMatchingParent = comparisonSpan;
            }
            if (bestMatchingParent == null) continue;
            span.addSpanReference(bestMatchingParent.getSpanContext(), RequestTraceSpan.SpanContextRelationshipType.ChildOf);
        }
    }

    private String logUnfinishedSpan(RequestTraceSpan span) {
        RequestTraceSpan root = this.trace.getFirst();
        StringBuilder sb = new StringBuilder(300);
        sb.append("Unfinished trace found during completion of trace ").append(root.getTraceId()).append(" tagged ").append(root.getSpanTags()).append("\nUnfinished span is ").append(span.getTraceId()).append(" tagged ").append(span.getSpanTags());
        return sb.toString();
    }

    @Override
    public int compareTo(RequestTrace requestTrace) {
        int compareElapsedTime = Long.compare(requestTrace.elapsedTime, this.elapsedTime);
        if (compareElapsedTime != 0) {
            return compareElapsedTime;
        }
        return requestTrace.startTime.compareTo(this.startTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTrace that = (RequestTrace)o;
        return this.elapsedTime == that.elapsedTime && (this.toString() != null ? this.toString().equals(that.toString()) : that.toString() == null);
    }

    public int hashCode() {
        int result = (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        result = 31 * result + (this.toString() != null ? this.toString().hashCode() : 0);
        return result;
    }
}

