/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.Toxic;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import eu.rekawek.toxiproxy.model.ToxicType;
import java.io.IOException;

public class Bandwidth
extends Toxic {
    private long rate;

    public Bandwidth(HttpClient httpClient, String toxicListPath, String name, ToxicDirection stream, long rate) throws IOException {
        super(httpClient, toxicListPath, name, stream);
        this.rate = rate;
        this.createToxic(toxicListPath);
    }

    public Bandwidth(HttpClient httpClient, String path, JsonObject json) {
        super(httpClient, path, json);
    }

    @Override
    protected void setAttributes(JsonObject attributes) {
        this.rate = attributes.get("rate").getAsLong();
    }

    @Override
    protected JsonObject getAttributes() {
        JsonObject attr = new JsonObject();
        attr.addProperty("rate", (Number)this.rate);
        return attr;
    }

    @Override
    protected ToxicType getType() {
        return ToxicType.BANDWIDTH;
    }

    public long getRate() {
        return this.rate;
    }

    public Bandwidth setRate(long rate) throws IOException {
        this.postAttribute("rate", rate);
        return this;
    }
}

