/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.os;

import android.os.Looper;
import android.os.Message;
import eu.livotov.labs.android.robotools.os.RTRunloop;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RTAsyncTask {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;
    private static final long REJECTED_TASK_RESUBMIT_TIMEOUT_MS = 1000L;
    private static final BlockingQueue<Runnable> asyncExecutionPool = new LinkedBlockingQueue<Runnable>(128);
    private static final RTRunloop serialExecutionPool = new RTRunloop();
    private static final Handler handler = new Handler();
    private static final ThreadFactory threadFactory = new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RTAsyncTask #" + this.count.getAndIncrement());
        }
    };
    public static final Executor threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, asyncExecutionPool, threadFactory, new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(final Runnable r, final ThreadPoolExecutor executor) {
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    executor.execute(r);
                }
            }, 1000L);
        }
    });
    private final Object lock = new Object();
    private AtomicBoolean taskCancelledFlag = new AtomicBoolean(false);
    private AsyncResult taskResult = new AsyncResult(this);

    protected void onPreExecute() {
    }

    protected void onProgressUpdate() {
    }

    protected void onPostExecute() {
    }

    protected void onError(Throwable t) {
    }

    protected void onCanceled() {
    }

    public void publishProgress() {
        if (!this.taskCancelledFlag.get()) {
            handler.dispatchProgressUpdate(this.taskResult);
        }
    }

    public void cancel() {
        this.taskCancelledFlag.set(true);
    }

    public boolean isCanceled() {
        return this.taskCancelledFlag.get();
    }

    public void execPool() {
        threadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RTAsyncTask.this.execInCurrThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInCurrThread() {
        Object object = this.lock;
        synchronized (object) {
            block11: {
                if (!this.taskCancelledFlag.get()) {
                    handler.dispatchPreExecute(this.taskResult);
                    if (!this.taskCancelledFlag.get()) {
                        try {
                            this.doInBackground();
                            if (!this.taskCancelledFlag.get()) {
                                handler.dispatchPostExecute(this.taskResult);
                                break block11;
                            }
                            handler.dispatchCancel(this.taskResult);
                        }
                        catch (Throwable throwable) {
                            if (!this.taskCancelledFlag.get()) {
                                this.taskResult.error = throwable;
                                handler.dispatchError(this.taskResult);
                                break block11;
                            }
                            handler.dispatchCancel(this.taskResult);
                        }
                    } else {
                        handler.dispatchCancel(this.taskResult);
                    }
                } else {
                    handler.dispatchCancel(this.taskResult);
                }
            }
        }
    }

    protected abstract void doInBackground() throws Throwable;

    public void execSerial() {
        if (!serialExecutionPool.isStarted()) {
            serialExecutionPool.start();
        }
        serialExecutionPool.post(new Runnable(){

            @Override
            public void run() {
                RTAsyncTask.this.execInCurrThread();
            }
        });
    }

    static class AsyncResult {
        final RTAsyncTask task;
        Throwable error;

        AsyncResult(RTAsyncTask task) {
            this.task = task;
        }
    }

    static class Handler
    extends android.os.Handler {
        static final int MESSAGE_PRE_EXECUTE = 1;
        static final int MESSAGE_PROGRESS = 2;
        static final int MESSAGE_ERROR = 3;
        static final int MESSAGE_CANCEL = 4;
        static final int MESSAGE_POST_EXECUTE = 5;

        Handler() {
            super(Looper.getMainLooper());
        }

        void dispatchPreExecute(AsyncResult result) {
            this.sendMessage(result, 1);
        }

        void sendMessage(AsyncResult result, int code) {
            Message m = this.obtainMessage(code);
            m.obj = result;
            m.sendToTarget();
        }

        void dispatchProgressUpdate(AsyncResult result) {
            this.sendMessage(result, 2);
        }

        void dispatchError(AsyncResult result) {
            this.sendMessage(result, 3);
        }

        void dispatchCancel(AsyncResult result) {
            this.sendMessage(result, 4);
        }

        void dispatchPostExecute(AsyncResult result) {
            this.sendMessage(result, 5);
        }

        public void handleMessage(Message msg) {
            AsyncResult obj = (AsyncResult)msg.obj;
            if (obj != null) {
                switch (msg.what) {
                    case 1: {
                        obj.task.onPreExecute();
                        break;
                    }
                    case 2: {
                        obj.task.onProgressUpdate();
                        break;
                    }
                    case 3: {
                        obj.task.onError(obj.error);
                        break;
                    }
                    case 4: {
                        obj.task.onCanceled();
                        break;
                    }
                    case 5: {
                        obj.task.onPostExecute();
                    }
                }
            }
        }
    }
}

