/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.ContactsContract;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsIntent;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;

public class RTShareTool {
    public static Intent buildCallIntent(@NonNull String number) {
        return new Intent("android.intent.action.CALL").setData(Uri.parse((String)(number.toLowerCase().startsWith("tel:") ? number : String.format("tel:%s", PhoneNumberUtils.stripSeparators((String)number)))));
    }

    public static Intent buildInternetAddressIntent(@NonNull String url) {
        return new Intent("android.intent.action.VIEW").setData(Uri.parse((String)url));
    }

    public static void openInternetAddressAsChromeTab(@NonNull Activity activity, @NonNull String url) {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.launchUrl(activity, Uri.parse((String)url));
    }

    public static Intent buildEmailIntent(@NonNull String to, @Nullable String subject, @Nullable String body) {
        Intent emailIntent = new Intent("android.intent.action.SEND");
        emailIntent.setType("plain/text");
        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{to});
        emailIntent.addFlags(0x10000000);
        if (!TextUtils.isEmpty((CharSequence)subject)) {
            emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            emailIntent.putExtra("android.intent.extra.TEXT", body);
        }
        return emailIntent;
    }

    public static Intent buildContactCardIntent(@NonNull String contactId) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_URI, (String)contactId);
        intent.setData(uri);
        intent.addFlags(0x10000000);
        return intent;
    }

    public static Intent buildShareTextIntent(@NonNull String text) {
        Intent textIntent = new Intent("android.intent.action.SEND");
        textIntent.setType("text/plain");
        textIntent.putExtra("android.intent.extra.TEXT", text);
        return textIntent;
    }

    public static Intent buildApplicationIntent(Context ctx, String packageName, boolean autoInstall) {
        PackageManager pm = ctx.getPackageManager();
        boolean packagePresent = false;
        try {
            pm.getPackageInfo(packageName, 1);
            packagePresent = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            packagePresent = false;
        }
        if (packagePresent) {
            return pm.getLaunchIntentForPackage(packageName);
        }
        if (autoInstall) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + packageName)));
        }
        return null;
    }
}

