/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.text;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class RTStringTokenizer {
    private ArrayList<String> tokens = new ArrayList();
    private int current = 0;

    public RTStringTokenizer(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter, true);
        boolean wasDelimiter = true;
        boolean isDelimiter = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            isDelimiter = token.equals(delimiter);
            if (wasDelimiter) {
                this.tokens.add(isDelimiter ? "" : token);
            } else if (!isDelimiter) {
                this.tokens.add(token);
            }
            wasDelimiter = isDelimiter;
        }
        if (isDelimiter) {
            this.tokens.add("");
        }
    }

    public int countTokens() {
        return this.tokens.size();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.current < this.tokens.size();
    }

    public String nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        String token = this.tokens.get(this.current);
        ++this.current;
        return token;
    }
}

