/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.fonts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import eu.livotov.labs.android.robotools.fonts.RTFontsHelper;
import java.util.Map;
import java.util.WeakHashMap;

public class RTWidgetFontsHelper {
    private static RTWidgetFontsHelper sInstance;
    private Context context;
    private String text;
    private int fontSizeSP = 18;
    private int color = -16777216;
    private String typeface;
    private Map<String, Bitmap> mBitmapCache = new WeakHashMap<String, Bitmap>();

    private RTWidgetFontsHelper(Context context) {
        this.context = context;
    }

    public static RTWidgetFontsHelper with(Context context) {
        if (sInstance == null) {
            sInstance = new RTWidgetFontsHelper(context);
        }
        return sInstance;
    }

    public RTWidgetFontsHelper text(String text) {
        this.text = text;
        return this;
    }

    public RTWidgetFontsHelper size(int size) {
        this.fontSizeSP = size;
        return this;
    }

    public RTWidgetFontsHelper color(int resId) {
        if (this.context == null) {
            throw new IllegalArgumentException("Context must be init first");
        }
        this.color = this.context.getResources().getColor(resId);
        return this;
    }

    public RTWidgetFontsHelper typeface(String typefaceName) {
        this.typeface = typefaceName;
        return this;
    }

    public Bitmap build() {
        if (this.context == null) {
            throw new IllegalArgumentException("Context must be not null");
        }
        if (TextUtils.isEmpty((CharSequence)this.text)) {
            throw new IllegalArgumentException("Text must be not empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.typeface)) {
            throw new IllegalArgumentException("Typeface must be not empty");
        }
        return RTWidgetFontsHelper.drawText(this.context, this.text, this.fontSizeSP, this.color, RTFontsHelper.getTypeface(this.context, this.typeface));
    }

    private static Bitmap drawText(Context context, String text, int fontSizeSP, int color, Typeface typeface) {
        if (!TextUtils.isEmpty((CharSequence)sInstance.key()) && RTWidgetFontsHelper.sInstance.mBitmapCache.containsKey(sInstance.key())) {
            return RTWidgetFontsHelper.sInstance.mBitmapCache.get(sInstance.key());
        }
        int fontSizePX = RTWidgetFontsHelper.convertDipToPix(context, fontSizeSP);
        Paint paint = new Paint(129);
        paint.setStyle(Paint.Style.FILL);
        paint.setTypeface(typeface);
        paint.setTextSize((float)fontSizePX);
        paint.setColor(color);
        int padding = fontSizePX / 10;
        int width = (int)(paint.measureText(text) + (float)(padding * 2));
        int height = fontSizePX + padding * 2;
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(result);
        int theY = fontSizePX;
        canvas.drawText(text, (float)padding, (float)theY, paint);
        RTWidgetFontsHelper.sInstance.mBitmapCache.put(sInstance.key(), result);
        return result;
    }

    @NonNull
    private String key() {
        return String.format("%s%s%s%s", this.text, this.typeface, this.fontSizeSP, this.color);
    }

    private static int convertDipToPix(Context context, float dip) {
        return (int)TypedValue.applyDimension((int)1, (float)dip, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

