/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.banking;

import android.text.TextUtils;

public class RTCreditCard {
    private RTCreditCard() {
    }

    public static boolean isValidCreditCardNumber(String number) {
        return RTCreditCard.getCreditCardType(number) != CreditCardType.UnknownOrInvalid && RTCreditCard.verifyCreditCardNumber(number);
    }

    public static boolean verifyCreditCardNumber(String n) {
        if (TextUtils.isEmpty((CharSequence)n)) {
            return false;
        }
        try {
            int j = n.length();
            String[] s1 = new String[j];
            for (int i = 0; i < n.length(); ++i) {
                s1[i] = "" + n.charAt(i);
            }
            int checksum = 0;
            for (int i = s1.length - 1; i >= 0; i -= 2) {
                int k = 0;
                if (i > 0) {
                    k = Integer.valueOf(s1[i - 1]) * 2;
                    if (k > 9) {
                        String s = "" + k;
                        k = Integer.valueOf(s.substring(0, 1)) + Integer.valueOf(s.substring(1));
                    }
                    checksum += Integer.valueOf(s1[i]) + k;
                    continue;
                }
                checksum += Integer.valueOf(s1[0]).intValue();
            }
            return checksum % 10 == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static CreditCardType getCreditCardType(String number) {
        String digit4;
        if (TextUtils.isEmpty((CharSequence)number)) {
            return CreditCardType.UnknownOrInvalid;
        }
        String digit1 = number.substring(0, 1);
        String digit2 = number.length() > 1 ? number.substring(0, 2) : null;
        String digit3 = number.length() > 2 ? number.substring(0, 3) : null;
        String string2 = digit4 = number.length() > 3 ? number.substring(0, 4) : null;
        if (TextUtils.isDigitsOnly((CharSequence)number.replaceAll(" ", ""))) {
            if ("4".equals(digit1)) {
                if (number.length() == 13 || number.length() == 16) {
                    return CreditCardType.Visa;
                }
            } else if ("51".compareTo(digit2) < 0 && "55".compareTo(digit2) > 0) {
                if (number.length() == 16) {
                    return CreditCardType.MasterCard;
                }
            } else if ("34".equals(digit2) || "37".equals(digit2)) {
                if (number.length() == 15) {
                    return CreditCardType.AmericanExpress;
                }
            } else if ("2014".equals(digit4) || "2149".equals(digit4)) {
                if (number.length() == 15) {
                    return CreditCardType.EnRoute;
                }
            } else if ("36".equals(digit2) || "38".equals(digit2) || "300".compareTo(digit3) < 0 && "305".compareTo(digit3) > 0) {
                if (number.length() == 14) {
                    return CreditCardType.Diners;
                }
            } else if (("5".equals(digit1) || "6".equals(digit1)) && number.length() >= 12 && number.length() <= 19) {
                return CreditCardType.Maestro;
            }
        }
        return CreditCardType.UnknownOrInvalid;
    }

    public static String formatCreditCardNumberForDisplay(String number) {
        String num = number.replaceAll(" ", "");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < num.length(); ++i) {
            buf.append(num.charAt(i));
            if (i != 3 && i != 7 && i != 11) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static CreditCardType guesstCreditCardType(String number) {
        String digit4;
        if (TextUtils.isEmpty((CharSequence)number)) {
            return CreditCardType.UnknownOrInvalid;
        }
        String digit1 = number.substring(0, 1);
        String digit2 = number.length() > 1 ? number.substring(0, 2) : null;
        String digit3 = number.length() > 2 ? number.substring(0, 3) : null;
        String string2 = digit4 = number.length() > 3 ? number.substring(0, 4) : null;
        if (TextUtils.isDigitsOnly((CharSequence)number.replaceAll(" ", ""))) {
            if ("4".equals(digit1)) {
                return CreditCardType.Visa;
            }
            if ("51".compareTo(digit2) < 0 && "55".compareTo(digit2) > 0) {
                return CreditCardType.MasterCard;
            }
            if ("34".equals(digit2) || "37".equals(digit2)) {
                return CreditCardType.AmericanExpress;
            }
            if ("2014".equals(digit4) || "2149".equals(digit4)) {
                return CreditCardType.EnRoute;
            }
            if ("36".equals(digit2) || "38".equals(digit2) || "300".compareTo(digit3) < 0 && "305".compareTo(digit3) > 0) {
                return CreditCardType.Diners;
            }
            if ("5".equals(digit1) || "6".equals(digit1)) {
                return CreditCardType.Maestro;
            }
        }
        return CreditCardType.UnknownOrInvalid;
    }

    public static enum CreditCardType {
        UnknownOrInvalid,
        Visa,
        MasterCard,
        AmericanExpress,
        EnRoute,
        Diners,
        Maestro;

    }
}

