/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.settings;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import eu.livotov.labs.android.robotools.text.RTBase64;
import java.util.StringTokenizer;

public class RTPrefs {
    private static RTPrefs defaultPreferences = null;
    protected SharedPreferences preferences;
    protected Context ctx;
    protected Gson gson = new Gson();

    public static synchronized RTPrefs getDefault(Context ctx) {
        if (defaultPreferences == null) {
            defaultPreferences = new RTPrefs(ctx, null);
        }
        return defaultPreferences;
    }

    public RTPrefs(Context ctx) {
        this(ctx, null, false);
    }

    public RTPrefs(Context ctx, String preferenceStorageName) {
        this(ctx, preferenceStorageName, false);
    }

    public RTPrefs(Context ctx, String preferenceStorageName, boolean privateMode) {
        this.ctx = ctx;
        this.preferences = TextUtils.isEmpty((CharSequence)preferenceStorageName) ? PreferenceManager.getDefaultSharedPreferences((Context)ctx) : ctx.getSharedPreferences(preferenceStorageName, RTPrefs.getPrefsMode(privateMode));
    }

    public String getString(int key, String defaultValue) {
        return this.getString(this.ctx.getString(key), defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.preferences.getString(key, defaultValue);
    }

    public void setString(int key, String value) {
        this.setString(this.ctx.getString(key), value);
    }

    public void setString(String key, String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public int getInt(int key, int defaultValue) {
        return this.getInt(this.ctx.getString(key), defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public void setInt(int key, int value) {
        this.setInt(this.ctx.getString(key), value);
    }

    public void setInt(String key, int value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public long getLong(int key, long defaultValue) {
        return this.getLong(this.ctx.getString(key), defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        try {
            return this.preferences.getLong(key, defaultValue);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return 0L;
        }
    }

    public void setLong(int key, long value) {
        this.setLong(this.ctx.getString(key), value);
    }

    public void setLong(String key, long value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public void setDouble(int key, double value) {
        this.setDouble(this.ctx.getString(key), value);
    }

    public void setDouble(String key, double value) {
        this.setString(key, "" + value);
    }

    public double getDouble(int key, double defaultValue) {
        return this.getDouble(this.ctx.getString(key), defaultValue);
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public boolean getBoolean(int key, boolean defaultValue) {
        return this.getBoolean(this.ctx.getString(key), defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public void setBoolean(int key, boolean value) {
        this.setBoolean(this.ctx.getString(key), value);
    }

    public void setBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public void setIntArray(int key, int[] array) {
        this.setString(key, this.arrayToString(array));
    }

    public void setIntArray(String key, int[] array) {
        this.setString(key, this.arrayToString(array));
    }

    public void setLongArray(int key, long[] array) {
        this.setString(key, this.arrayToString(array));
    }

    public void setLongArray(String key, long[] array) {
        this.setString(key, this.arrayToString(array));
    }

    public void setByteArray(int key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public void setByteArray(String key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public int[] getIntArray(int key) {
        return this.stringToIntegerArray(this.getString(key, ""));
    }

    public int[] getIntArray(String key) {
        return this.stringToIntegerArray(this.getString(key, ""));
    }

    public long[] getLongArray(int key) {
        return this.stringToLongArray(this.getString(key, ""));
    }

    public long[] getLongArray(String key) {
        return this.stringToLongArray(this.getString(key, ""));
    }

    public byte[] getByteArray(int key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public byte[] getByteArray(String key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public <T> T getObject(Class<T> clazz, int key, T defaultValue) {
        return this.getObject(clazz, this.ctx.getString(key), defaultValue);
    }

    public <T> T getObject(Class<T> clazz, String key, T defaultValue) {
        try {
            return (T)this.gson.fromJson(this.getString(key, ""), clazz);
        }
        catch (Throwable ignored) {
            return defaultValue;
        }
    }

    public void setObject(int key, Object object) {
        this.setObject(this.ctx.getString(key), object);
    }

    public void setObject(String key, Object object) {
        try {
            if (object != null) {
                this.setString(key, this.gson.toJson(object));
            } else {
                this.remove(key);
            }
        }
        catch (Throwable err) {
            throw new IllegalArgumentException("Cannot convert to JSON: " + object.toString(), err);
        }
    }

    public void remove(int key) {
        this.remove(this.ctx.getString(key));
    }

    public void remove(String key) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(key);
        editor.commit();
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    public SharedPreferences getPreferences() {
        return this.preferences;
    }

    protected static int getPrefsMode(boolean privateMode) {
        if (Build.VERSION.SDK_INT >= 11 && !privateMode) {
            return 4;
        }
        return 0;
    }

    protected String arrayToString(int[] array) {
        StringBuffer str = new StringBuffer();
        for (int a : array) {
            if (str.length() > 0) {
                str.append("|");
            }
            str.append("" + a);
        }
        return str.toString();
    }

    protected String arrayToString(long[] array) {
        StringBuffer str = new StringBuffer();
        for (long a : array) {
            if (str.length() > 0) {
                str.append("|");
            }
            str.append("" + a);
        }
        return str.toString();
    }

    protected int[] stringToIntegerArray(String str) {
        StringTokenizer tok = new StringTokenizer(str, "|", false);
        if (tok.countTokens() > 0) {
            int[] arr = new int[tok.countTokens()];
            int index = 0;
            while (tok.hasMoreTokens()) {
                arr[index] = Integer.parseInt(tok.nextToken());
                ++index;
            }
            return arr;
        }
        return null;
    }

    protected long[] stringToLongArray(String str) {
        StringTokenizer tok = new StringTokenizer(str, "|", false);
        if (tok.countTokens() > 0) {
            long[] arr = new long[tok.countTokens()];
            int index = 0;
            while (tok.hasMoreTokens()) {
                arr[index] = Long.parseLong(tok.nextToken());
                ++index;
            }
            return arr;
        }
        return null;
    }
}

