/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.injector.ann;

import android.content.IntentFilter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface InjectReceiver {
    public String[] action() default {};

    public String[] category() default {};

    public static final class Processor {
        public static IntentFilter process(InjectReceiver receiver) {
            IntentFilter filter = new IntentFilter();
            String[] actions = receiver.action();
            String[] categories = receiver.category();
            if (actions != null) {
                for (String action : actions) {
                    filter.addAction(action);
                }
            }
            if (categories != null) {
                for (String category : categories) {
                    filter.addCategory(category);
                }
            }
            return filter;
        }
    }
}

