/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera.v1;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import eu.livotov.labs.android.camview.camera.v1.ImageParameters;
import java.util.Collection;
import java.util.List;

public class CameraUtilsV1 {
    static String findSettableValue(Collection<String> supportedValues, String ... desiredValues) {
        String result = null;
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                result = desiredValue;
                break;
            }
        }
        return result;
    }

    static Camera.Parameters getMainCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        if (Build.VERSION.SDK_INT >= 9) {
            CameraUtilsV1.setFocusMode(parameters);
        }
        if (Build.VERSION.SDK_INT > 13) {
            CameraUtilsV1.setAutoExposureLock(parameters);
        }
        if (Build.VERSION.SDK_INT > 7) {
            try {
                if (parameters.getMaxExposureCompensation() != 0 || parameters.getMinExposureCompensation() != 0) {
                    parameters.setExposureCompensation(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return parameters;
    }

    @TargetApi(value=14)
    static String getFocusMode14(List<String> focusModes) {
        boolean safeMode = false;
        if (safeMode) {
            return CameraUtilsV1.findSettableValue(focusModes, "auto");
        }
        return CameraUtilsV1.findSettableValue(focusModes, "continuous-picture", "continuous-video", "auto");
    }

    @TargetApi(value=9)
    static String getFocusMode9(List<String> focusModes) {
        return CameraUtilsV1.findSettableValue(focusModes, "auto");
    }

    @TargetApi(value=9)
    static void setFocusMode(Camera.Parameters parameters) {
        List focusModes = parameters.getSupportedFocusModes();
        String focusMode = Build.VERSION.SDK_INT >= 14 ? CameraUtilsV1.getFocusMode14(focusModes) : CameraUtilsV1.getFocusMode9(focusModes);
        if (null == focusMode) {
            focusMode = CameraUtilsV1.findSettableValue(focusModes, "macro", "edof");
        }
        if (null != focusMode) {
            parameters.setFocusMode(focusMode);
        }
    }

    @TargetApi(value=14)
    static void setAutoExposureLock(Camera.Parameters parameters) {
        try {
            if (parameters.isAutoExposureLockSupported()) {
                parameters.setAutoExposureLock(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Camera.Parameters getFailsafeCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        if (Build.VERSION.SDK_INT >= 9) {
            CameraUtilsV1.setFocusMode(parameters);
        }
        return parameters;
    }

    static void setupSurfaceAndCameraForPreview(int cameraId, Camera camera, SurfaceView surfaceView) {
        int displayOrientation;
        ImageParameters mImageParameters = new ImageParameters();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        int rotation = ((WindowManager)surfaceView.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (cameraInfo.facing == 1) {
            displayOrientation = (cameraInfo.orientation + degrees) % 360;
            displayOrientation = (360 - displayOrientation) % 360;
        } else {
            displayOrientation = (cameraInfo.orientation - degrees + 360) % 360;
        }
        mImageParameters.mDisplayOrientation = displayOrientation;
        mImageParameters.mLayoutOrientation = degrees;
        camera.setDisplayOrientation(mImageParameters.mDisplayOrientation);
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size sz = CameraUtilsV1.getOptimalPreviewSize(parameters.getSupportedPreviewSizes(), surfaceView.getWidth(), surfaceView.getHeight());
        parameters.setPreviewSize(sz.width, sz.height);
        float ratio = 0.0f;
        ratio = surfaceView.getContext().getResources().getConfiguration().orientation == 2 ? (float)sz.width / (float)sz.height : (float)sz.height / (float)sz.width;
        int new_width = 0;
        int new_height = 0;
        if ((float)(surfaceView.getWidth() / surfaceView.getHeight()) < ratio) {
            new_width = Math.round((float)surfaceView.getHeight() * ratio);
            new_height = surfaceView.getHeight();
        } else {
            new_width = surfaceView.getWidth();
            new_height = Math.round((float)surfaceView.getWidth() / ratio);
        }
        FrameLayout.LayoutParams prms = new FrameLayout.LayoutParams(new_width, new_height);
        prms.gravity = 17;
        surfaceView.setLayoutParams((ViewGroup.LayoutParams)prms);
        List focus = parameters.getSupportedFocusModes();
        boolean af = focus.contains("auto");
        if (af) {
            if (focus.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (focus.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            }
        } else if (focus.contains("infinity")) {
            parameters.setFocusMode("infinity");
        } else if (focus.contains("fixed")) {
            parameters.setFocusMode("fixed");
        }
        camera.setParameters(parameters);
    }

    private static Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int w, int h) {
        double aspectToolerance = 0.1;
        double targetRatio = (double)h / (double)w;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - h) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - h);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - h) < minDiff) || size.width < w) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - h);
            }
        }
        return optimalSize;
    }
}

