/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import eu.livotov.labs.android.camview.R;
import eu.livotov.labs.android.camview.camera.LiveDataProcessingCallback;
import eu.livotov.labs.android.camview.camera.LiveFrameProcessingHandler;
import java.util.concurrent.CountDownLatch;

public class LiveFrameProcessingThread
extends Thread {
    private final CountDownLatch handlerInitLatch = new CountDownLatch(1);
    private Handler decoderHandler;
    private Handler uiHandler;
    private LiveDataProcessingCallback processor;

    public LiveFrameProcessingThread(Handler uiHandler, LiveDataProcessingCallback processor) {
        this.uiHandler = uiHandler;
        this.processor = processor;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.decoderHandler = new LiveFrameProcessingHandler(this.uiHandler, this.processor);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }

    public void shutdown() {
        Message message = Message.obtain((Handler)this.getDecoderHandler(), (int)R.id.camview_core_msg_livedataprocess_quit);
        if (message != null) {
            message.sendToTarget();
        }
    }

    Handler getDecoderHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.decoderHandler;
    }

    public void submitLiveFrame(byte[] bytes, int width, int height) {
        this.getDecoderHandler().removeMessages(R.id.camview_core_msg_livedataprocess_request);
        Message message = Message.obtain((Handler)this.getDecoderHandler(), (int)R.id.camview_core_msg_livedataprocess_request, (int)width, (int)height, (Object)bytes);
        if (message != null) {
            message.sendToTarget();
        }
    }
}

