/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera;

import android.os.Handler;
import android.os.Message;
import eu.livotov.labs.android.camview.R;
import eu.livotov.labs.android.camview.camera.CameraController;
import eu.livotov.labs.android.camview.camera.LiveDataProcessingCallback;
import eu.livotov.labs.android.camview.camera.LiveFrameProcessingThread;

public abstract class AbstractController
implements CameraController {
    protected LiveDataProcessingCallback liveDataProcessor;
    protected LiveFrameProcessingThread liveFrameProcessingThread;

    protected void startLiveDataCapture(LiveDataProcessingCallback processor) {
        this.liveDataProcessor = processor;
        if (this.liveFrameProcessingThread == null) {
            this.liveFrameProcessingThread = new LiveFrameProcessingThread(new ProcessingResultHandler(), processor);
            this.liveFrameProcessingThread.start();
        }
    }

    protected void stopLiveDataCapture() {
        if (this.liveFrameProcessingThread != null) {
            this.liveFrameProcessingThread.shutdown();
        }
    }

    class ProcessingResultHandler
    extends Handler {
        ProcessingResultHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == R.id.camview_core_msg_livedataprocess_ok && AbstractController.this.liveDataProcessor != null) {
                AbstractController.this.liveDataProcessor.onReceiveProcessedCameraFrame(msg.obj);
            }
        }
    }
}

