/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera;

import android.os.Handler;
import android.os.Message;
import eu.livotov.labs.android.camview.R;
import eu.livotov.labs.android.camview.camera.LiveDataProcessingCallback;

public class LiveFrameProcessingHandler
extends Handler {
    private static final String TAG = LiveFrameProcessingHandler.class.getSimpleName();
    private Handler uiHandler;
    private LiveDataProcessingCallback callback;
    private boolean running = true;

    LiveFrameProcessingHandler(Handler uiHandler, LiveDataProcessingCallback callback) {
        this.uiHandler = uiHandler;
        this.callback = callback;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        if (message.what == R.id.camview_core_msg_livedataprocess_request) {
            this.decode((byte[])message.obj, message.arg1, message.arg2);
        }
    }

    private void decode(byte[] data, int width, int height) {
        try {
            this.uiHandler.removeMessages(R.id.camview_core_msg_livedataprocess_ok);
            Object result = this.callback.onProcessCameraFrame(data, width, height);
            Message.obtain((Handler)this.uiHandler, (int)R.id.camview_core_msg_livedataprocess_ok, (Object)result).sendToTarget();
        }
        catch (Throwable err) {
            // empty catch block
        }
    }
}

