/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera;

import android.os.Looper;
import android.os.Message;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CAMViewAsyncTask<Params, Progress, Result> {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
    private static final Runloop sRunLoop = new Runloop();
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    public static final Executor sPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    private static final Handler sHandler = new Handler();
    private final Object mLock = new Object();
    private AtomicBoolean mCancelled = new AtomicBoolean(false);

    protected void onPreExecute() {
    }

    protected abstract Result doInBackground(Params ... var1) throws Throwable;

    protected void onProgressUpdate(Progress progress) {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onError(Throwable t) {
    }

    protected void onCanceled(Result result) {
    }

    public void publishProgress(Progress progress) {
        if (!this.mCancelled.get()) {
            AsyncResult result = new AsyncResult(this);
            result.progress = progress;
            sHandler.dispatchProgressUpdate(result);
        }
    }

    public void cancel() {
        this.mCancelled.set(true);
    }

    public boolean isCanceled() {
        return this.mCancelled.get();
    }

    public void execPool(final Params ... params) {
        sPool.execute(new Runnable(){

            @Override
            public void run() {
                CAMViewAsyncTask.this.execInCurrThread(params);
            }
        });
    }

    public void execSerial(final Params ... params) {
        if (!sRunLoop.isStarted()) {
            sRunLoop.start();
        }
        sRunLoop.post(new Runnable(){

            @Override
            public void run() {
                CAMViewAsyncTask.this.execInCurrThread(params);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInCurrThread(Params ... params) {
        Object object = this.mLock;
        synchronized (object) {
            block11: {
                AsyncResult result = new AsyncResult(this);
                if (!this.mCancelled.get()) {
                    sHandler.dispatchPreExecute(result);
                    if (!this.mCancelled.get()) {
                        try {
                            result.result = this.doInBackground(params);
                            if (!this.mCancelled.get()) {
                                sHandler.dispatchPostExecute(result);
                                break block11;
                            }
                            sHandler.dispatchCancel(result);
                        }
                        catch (Throwable throwable) {
                            if (!this.mCancelled.get()) {
                                sHandler.dispatchError(result);
                                break block11;
                            }
                            sHandler.dispatchCancel(result);
                        }
                    } else {
                        sHandler.dispatchCancel(result);
                    }
                } else {
                    sHandler.dispatchCancel(result);
                }
            }
        }
    }

    static class Runloop
    extends Thread {
        private final Object mLock = new Object();
        private android.os.Handler mHandler;
        private boolean mReady = false;

        Runloop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            this.mHandler = new android.os.Handler();
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
                this.mReady = true;
            }
            Looper.loop();
        }

        public void sendMessage(Message message) {
            this.sendMessage(message, 0L);
        }

        public void post(Runnable runnable) {
            this.post(runnable, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Message message, long delayMillis) {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mReady) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mHandler != null) {
                    if (delayMillis <= 0L) {
                        this.mHandler.sendMessage(message);
                    } else {
                        this.mHandler.sendMessageDelayed(message, delayMillis);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(Runnable runnable, long delayMillis) {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mReady) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mHandler != null) {
                    if (delayMillis <= 0L) {
                        this.mHandler.post(runnable);
                    } else {
                        this.mHandler.postDelayed(runnable, delayMillis);
                    }
                }
            }
        }

        public boolean isStarted() {
            return this.mReady;
        }
    }

    static class AsyncResult<Progress, Result> {
        final CAMViewAsyncTask task;
        Throwable t;
        Progress progress;
        Result result;

        AsyncResult(CAMViewAsyncTask task) {
            this.task = task;
        }
    }

    static class Handler
    extends android.os.Handler {
        static final int MESSAGE_PRE_EXECUTE = 1;
        static final int MESSAGE_PROGRESS = 2;
        static final int MESSAGE_ERROR = 3;
        static final int MESSAGE_CANCEL = 4;
        static final int MESSAGE_POST_EXECUTE = 5;

        Handler() {
            super(Looper.getMainLooper());
        }

        void dispatchPreExecute(AsyncResult result) {
            this.sendMessage(result, 1);
        }

        void dispatchProgressUpdate(AsyncResult result) {
            this.sendMessage(result, 2);
        }

        void dispatchError(AsyncResult result) {
            this.sendMessage(result, 3);
        }

        void dispatchCancel(AsyncResult result) {
            this.sendMessage(result, 4);
        }

        void dispatchPostExecute(AsyncResult result) {
            this.sendMessage(result, 5);
        }

        void sendMessage(AsyncResult result, int code) {
            Message m = this.obtainMessage(code);
            m.obj = result;
            m.sendToTarget();
        }

        public void handleMessage(Message msg) {
            AsyncResult obj = (AsyncResult)msg.obj;
            if (obj != null) {
                switch (msg.what) {
                    case 1: {
                        obj.task.onPreExecute();
                        break;
                    }
                    case 2: {
                        obj.task.onProgressUpdate(obj.progress);
                        break;
                    }
                    case 3: {
                        obj.task.onError(obj.t);
                        break;
                    }
                    case 4: {
                        obj.task.onCanceled(obj.result);
                        break;
                    }
                    case 5: {
                        obj.task.onPostExecute(obj.result);
                    }
                }
            }
        }
    }
}

