/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import eu.livotov.labs.android.camview.CameraLiveView;
import eu.livotov.labs.android.camview.R;
import eu.livotov.labs.android.camview.camera.CameraController;
import eu.livotov.labs.android.camview.camera.CameraInfo;
import eu.livotov.labs.android.camview.camera.CameraManager;
import eu.livotov.labs.android.camview.camera.LiveDataProcessingCallback;
import eu.livotov.labs.android.camview.scanner.decoder.BarcodeDecoder;
import eu.livotov.labs.android.camview.scanner.decoder.zxing.ZXDecoder;
import eu.livotov.labs.android.camview.scanner.util.SoundPlayer;
import java.util.Collection;

public class ScannerLiveView
extends FrameLayout
implements LiveDataProcessingCallback,
CameraLiveView.CameraLiveViewEventsListener {
    public static final long DEFAULT_SAMECODE_RESCAN_PROTECTION_TIME_MS = 5000L;
    public static final long DEFAULT_DECODE_THROTTLE_MS = 300L;
    protected CameraLiveView camera;
    protected ImageView hud;
    protected ScannerViewEventListener scannerViewEventListener;
    protected BarcodeDecoder decoder = new ZXDecoder();
    protected int scannerSoundAudioResource = R.raw.camview_beep;
    protected boolean playSound = true;
    protected SoundPlayer soundPlayer;
    private volatile String lastDataDecoded;
    private volatile long lastDataDecodedTimestamp;
    private volatile long decodeThrottleMillis = 300L;
    private volatile long sameCodeRescanProtectionTime = 5000L;
    private CameraController controller;
    private long lastTimeFrameProcessed;

    public ScannerLiveView(Context context) {
        super(context);
        this.initUI();
    }

    protected void initUI() {
        View root = LayoutInflater.from((Context)this.getContext()).inflate(this.getScannerLayoutResource(), (ViewGroup)this);
        this.camera = (CameraLiveView)root.findViewById(R.id.camview_camera);
        this.hud = (ImageView)root.findViewById(R.id.cameraHud);
        this.decoder = new ZXDecoder();
        this.soundPlayer = new SoundPlayer(this.getContext());
        this.camera.setCameraLiveViewEventsListener(this);
    }

    protected int getScannerLayoutResource() {
        return R.layout.camview_view_scanner;
    }

    public ScannerLiveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initUI();
    }

    public ScannerLiveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initUI();
    }

    public BarcodeDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(BarcodeDecoder decoder) {
        this.decoder = decoder;
    }

    @TargetApi(value=21)
    public ScannerLiveView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initUI();
    }

    public Collection<CameraInfo> getAvailableCameras() {
        return CameraManager.getAvailableCameras(this.getContext());
    }

    public void startScanner() {
        this.startScanner(null);
    }

    public void startScanner(CameraInfo camInfo) {
        this.lastDataDecoded = null;
        CameraInfo finalCamera = camInfo;
        if (finalCamera == null) {
            finalCamera = CameraManager.findDefaultCamera(this.getContext());
        }
        if (finalCamera == null) {
            throw new RuntimeException("Cannot find any camera on device");
        }
        this.camera.startCamera(finalCamera);
    }

    private void resumeGrabbing() {
        if (this.controller != null) {
            this.controller.requestLiveData(this);
        }
    }

    public void stopScanner() {
        this.camera.stopCamera();
    }

    public long getSameCodeRescanProtectionTime() {
        return this.sameCodeRescanProtectionTime;
    }

    public void setSameCodeRescanProtectionTime(long sameCodeRescanProtectionTime) {
        this.sameCodeRescanProtectionTime = sameCodeRescanProtectionTime;
    }

    public long getDecodeThrottleMillis() {
        return this.decodeThrottleMillis;
    }

    public void setDecodeThrottleMillis(long throttle) {
        this.decodeThrottleMillis = throttle;
    }

    public CameraLiveView getCamera() {
        return this.camera;
    }

    public ScannerViewEventListener getScannerViewEventListener() {
        return this.scannerViewEventListener;
    }

    public void setScannerViewEventListener(ScannerViewEventListener scannerViewEventListener) {
        this.scannerViewEventListener = scannerViewEventListener;
    }

    public void setScannerSoundAudioResource(int scannerSoundAudioResource) {
        this.scannerSoundAudioResource = scannerSoundAudioResource;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    public void setHudImageResource(int res) {
        if (this.hud != null) {
            this.hud.setBackgroundResource(res);
            this.setHudVisible(res != 0);
        }
    }

    public void setHudVisible(boolean visible) {
        if (this.hud != null) {
            this.hud.setVisibility(visible ? 0 : 4);
        }
    }

    protected void notifyBarcodeRead(String data) {
        this.beep();
        if (this.scannerViewEventListener != null && !TextUtils.isEmpty((CharSequence)data)) {
            this.scannerViewEventListener.onCodeScanned(data);
        }
    }

    private void beep() {
        if (this.playSound && this.scannerSoundAudioResource != 0) {
            this.soundPlayer.playRawResource(this.scannerSoundAudioResource, false);
        }
    }

    @Override
    public Object onProcessCameraFrame(byte[] data, int width, int height) {
        if (System.currentTimeMillis() - this.lastTimeFrameProcessed > this.decodeThrottleMillis) {
            String result = this.decoder.decode(data, width, height);
            this.lastTimeFrameProcessed = System.currentTimeMillis();
            return result;
        }
        return null;
    }

    @Override
    public void onReceiveProcessedCameraFrame(Object object) {
        String data;
        String string = data = object != null ? object.toString() : null;
        if (!TextUtils.isEmpty((CharSequence)data) && (TextUtils.isEmpty((CharSequence)this.lastDataDecoded) || !this.lastDataDecoded.equalsIgnoreCase(data) || this.lastDataDecoded.equalsIgnoreCase(data) && System.currentTimeMillis() - this.lastDataDecodedTimestamp > this.sameCodeRescanProtectionTime)) {
            this.lastDataDecoded = data;
            this.lastDataDecodedTimestamp = System.currentTimeMillis();
            this.notifyBarcodeRead(data);
        }
        this.resumeGrabbing();
    }

    @Override
    public void onCameraStarted(CameraLiveView camera) {
        this.controller = camera.getController();
        this.resumeGrabbing();
        if (this.scannerViewEventListener != null) {
            this.scannerViewEventListener.onScannerStarted(this);
        }
    }

    @Override
    public void onCameraStopped(CameraLiveView camera) {
        if (this.scannerViewEventListener != null) {
            this.scannerViewEventListener.onScannerStopped(this);
        }
    }

    @Override
    public void onCameraError(Throwable err) {
        if (this.scannerViewEventListener != null) {
            this.scannerViewEventListener.onScannerError(err);
        }
    }

    public static interface ScannerViewEventListener {
        public void onScannerStarted(ScannerLiveView var1);

        public void onScannerStopped(ScannerLiveView var1);

        public void onScannerError(Throwable var1);

        public void onCodeScanned(String var1);
    }
}

