/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Log;
import eu.livotov.labs.android.camview.camera.CameraController;
import eu.livotov.labs.android.camview.camera.CameraDelayedOperationResult;
import eu.livotov.labs.android.camview.camera.CameraInfo;
import eu.livotov.labs.android.camview.camera.v1.DefaultCameraV1Controller;
import eu.livotov.labs.android.camview.camera.v2.DefaultCameraV2Controller;
import java.util.ArrayList;
import java.util.Collection;

public class CameraManager {
    public static Collection<CameraInfo> getAvailableCameras(Context ctx) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CameraManager.enumerateCamerasViaApiV2(ctx);
        }
        return CameraManager.enumerateCamerasViaApiV1();
    }

    public static CameraInfo findFrontCamera(Context ctx) {
        for (CameraInfo cameraInfo : CameraManager.getAvailableCameras(ctx)) {
            if (!cameraInfo.isFrontFacingCamera()) continue;
            return cameraInfo;
        }
        return null;
    }

    public static CameraInfo findDefaultCamera(Context ctx) {
        for (CameraInfo cameraInfo : CameraManager.getAvailableCameras(ctx)) {
            if (cameraInfo.isFrontFacingCamera()) continue;
            return cameraInfo;
        }
        return null;
    }

    public static CameraController open(CameraInfo camera) {
        return CameraManager.open(camera, null);
    }

    public static CameraController open(CameraInfo camera, CameraDelayedOperationResult callback) {
        if (Build.VERSION.SDK_INT >= 21) {
            return CameraManager.openCameraWithApiV1(camera, callback);
        }
        return CameraManager.openCameraWithApiV1(camera, callback);
    }

    @TargetApi(value=21)
    private static Collection<CameraInfo> enumerateCamerasViaApiV2(Context ctx) {
        ArrayList<CameraInfo> cameras = new ArrayList<CameraInfo>();
        android.hardware.camera2.CameraManager manager = (android.hardware.camera2.CameraManager)ctx.getSystemService("camera");
        try {
            String[] cams;
            String[] stringArray = cams = manager.getCameraIdList();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String camId;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(camId = stringArray[i]);
                cameras.add(new CameraInfo(camId, (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) == 0));
            }
        }
        catch (CameraAccessException cae) {
            Log.e((String)CameraManager.class.getSimpleName(), (String)cae.getMessage(), (Throwable)cae);
        }
        return cameras;
    }

    @TargetApi(value=20)
    private static Collection<CameraInfo> enumerateCamerasViaApiV1() {
        ArrayList<CameraInfo> cameras = new ArrayList<CameraInfo>();
        int camerasCount = Camera.getNumberOfCameras();
        for (int id2 = 0; id2 < camerasCount; ++id2) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
            cameras.add(new CameraInfo("" + id2, cameraInfo.facing == 1));
        }
        return cameras;
    }

    @TargetApi(value=21)
    private static CameraController openCameraWithApiV2(CameraInfo camera, CameraDelayedOperationResult callback) {
        return new DefaultCameraV2Controller(camera, callback);
    }

    private static CameraController openCameraWithApiV1(CameraInfo camera, CameraDelayedOperationResult callback) {
        return new DefaultCameraV1Controller(camera, callback);
    }
}

