/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.model.Digest;
import java.util.LinkedHashMap;
import java.util.Map;

public class SignaturePolicyValidationResult {
    private boolean identified = false;
    private boolean asn1Processable = false;
    private boolean digestAlgorithmsEqual = false;
    private boolean digestValid = false;
    private Digest digest;
    private Map<String, String> errors;

    public boolean isIdentified() {
        return this.identified;
    }

    public void setIdentified(boolean identified) {
        this.identified = identified;
    }

    public boolean isDigestValid() {
        return this.digestValid;
    }

    public void setDigestValid(boolean digestValid) {
        this.digestValid = digestValid;
    }

    public boolean isAsn1Processable() {
        return this.asn1Processable;
    }

    public void setAsn1Processable(boolean asn1Processable) {
        this.asn1Processable = asn1Processable;
    }

    public boolean isDigestAlgorithmsEqual() {
        return this.digestAlgorithmsEqual;
    }

    public void setDigestAlgorithmsEqual(boolean digestAlgorithmsEqual) {
        this.digestAlgorithmsEqual = digestAlgorithmsEqual;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }

    protected Map<String, String> getErrors() {
        if (this.errors == null) {
            this.errors = new LinkedHashMap<String, String>();
        }
        return this.errors;
    }

    public void addError(String errorKey, String errorMessage) {
        Map<String, String> errors = this.getErrors();
        errors.put(errorKey, errorMessage);
    }

    public String getProcessingErrors() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> errors = this.getErrors();
        if (!errors.isEmpty()) {
            stringBuilder.append("The errors found on signature policy validation are:");
            for (Map.Entry<String, String> entry : errors.entrySet()) {
                stringBuilder.append(" at ").append(entry.getKey()).append(": ").append(entry.getValue()).append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

