/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String quote(Object object) {
        return "\"" + object.toString() + "\"";
    }

    public static List<String> splitInto(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (matcher.find(i)) {
            if (i < matcher.start()) {
                throw new IllegalArgumentException("Could not split string into specified pattern.  Found matches '" + Joiner.on((String)", ").join(parts) + "' and then '" + string.charAt(i) + "' found between matches.");
            }
            if (matcher.groupCount() > 0) {
                parts.add(matcher.group(1));
            } else {
                parts.add(matcher.group(0));
            }
            i = matcher.end();
        }
        if (i != string.length()) {
            throw new IllegalArgumentException("Pattern does not extend to end of string: " + i + "/" + string.length());
        }
        return parts;
    }

    public static String indent(String string, String indent) {
        Pattern pattern = Pattern.compile("^", 8);
        return pattern.matcher(string).replaceAll(indent);
    }

    public static String indent(String string) {
        return StringUtils.indent(string, "    ");
    }

    public static List<String> tokenize(String string, Pattern[] patterns) {
        Pattern whitespace = Pattern.compile("\\s+");
        return StringUtils.tokenize(string, patterns, whitespace);
    }

    public static List<String> tokenize(String string, Pattern[] patterns, Pattern ignore) {
        ArrayList<String> tokens = new ArrayList<String>(string.length());
        int start = 0;
        while (start < string.length()) {
            Matcher match = null;
            match = ignore.matcher(string).region(start, string.length());
            if (match.lookingAt()) {
                start = match.end();
                continue;
            }
            boolean matched = false;
            for (Pattern p : patterns) {
                match = p.matcher(string).region(start, string.length());
                if (!match.lookingAt()) continue;
                tokens.add(match.group(0));
                start = match.end();
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException("Un-tokenizable string: '" + string.substring(start) + "'");
        }
        return tokens;
    }

    public static int indexOfClose(String string, int start, char open, char close) {
        --start;
        int count = 0;
        do {
            if (++start >= string.length()) {
                return -1;
            }
            char c = string.charAt(start);
            if (c == open) {
                ++count;
                continue;
            }
            if (c != close) continue;
            --count;
        } while (count > 0);
        return start;
    }
}

