/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

import java.io.FileNotFoundException;
import java.io.InputStream;

public class ResourceUtils {
    public static InputStream loadResourceFromClasspath(String name, Class<?> loader) {
        return loader.getClassLoader().getResourceAsStream(name);
    }

    public static InputStream loadResourceFromPackageRoot(String name, Class<?> loader) {
        return loader.getResourceAsStream("/" + name);
    }

    public static InputStream loadResourceFromPackage(String name, Class<?> loader) {
        return loader.getResourceAsStream(name);
    }

    public static InputStream loadResource(String name, Class<?> loader) throws FileNotFoundException {
        InputStream stream = ResourceUtils.loadResourceFromPackageRoot(name, loader);
        if (stream != null) {
            return stream;
        }
        stream = ResourceUtils.loadResourceFromPackage(name, loader);
        if (stream != null) {
            return stream;
        }
        stream = ResourceUtils.loadResourceFromClasspath(name, loader);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("Could not find resource '" + name + "' (null returned).");
    }
}

