/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.commonlib.AbstractRange;
import edu.washington.cs.knowitall.commonlib.Range;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeSet
extends AbstractRange
implements Serializable {
    private static final long serialVersionUID = -5916908704306283230L;
    private final int start;
    private final int end;
    private final List<Range> ranges;

    public RangeSet(Range[] ranges) {
        ArrayList<Range> rangeList = new ArrayList<Range>(ranges.length);
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Range range : ranges) {
            if (range.isEmpty()) continue;
            rangeList.add(range);
            start = Math.min(start, range.getStart());
            end = Math.max(start, range.getStart());
        }
        this.start = start;
        this.end = end;
        this.ranges = new ArrayList<Range>(rangeList.size());
        Collections.sort(rangeList);
        for (int i = 0; i < rangeList.size() - 1; ++i) {
            Range next;
            Range current = (Range)rangeList.get(i);
            if (current.isAdjacentOrOverlaps(next = (Range)rangeList.get(i + 1))) {
                rangeList.set(i + 1, current.join(next));
                continue;
            }
            this.ranges.add(current);
        }
        this.ranges.add((Range)rangeList.get(rangeList.size() - 1));
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.size() == 0;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(int i) {
        for (Range range : this.ranges) {
            if (!range.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Range otherRange) {
        for (Range range : this.ranges) {
            if (!range.contains(otherRange)) continue;
            return true;
        }
        return false;
    }

    public static RangeSet getLeft(RangeSet range1, RangeSet range2) {
        if (range1.getStart() <= range2.getStart()) {
            return range1;
        }
        return range2;
    }

    public static RangeSet getRight(RangeSet range1, RangeSet range2) {
        if (range1.getStart() > range2.getStart()) {
            return range1;
        }
        return range2;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        for (Range range : this.ranges) {
            parts.add(range.toString());
        }
        return Joiner.on((String)", ").join(parts);
    }
}

