/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.commonlib.AbstractRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Range
extends AbstractRange
implements Iterable<Integer>,
Comparable<Range>,
Serializable {
    private static final long serialVersionUID = -5916908704306283230L;
    public static final Range EMPTY = new Range(0, 0);
    private final int start;
    private final int length;
    private static final Comparator<Range> startComparator = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            Integer s1 = o1.getStart();
            return s1.compareTo(o2.getStart());
        }
    };

    public Range(int start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Range length must be >= 0: " + length);
        }
        if (start < 0) {
            throw new IllegalArgumentException("Range start must be >= 0: " + start);
        }
        this.start = start;
        this.length = length;
    }

    public Range(int index) {
        this(index, 1);
    }

    public static Range fromInterval(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Range start must be >= 0: " + start);
        }
        if (end < 0) {
            throw new IllegalArgumentException("Range end must be >= 0: " + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("Range end must be >= start: " + end + "<" + start);
        }
        return new Range(start, end - start);
    }

    public int size() {
        return this.getLength();
    }

    public Range shift(int n) {
        return new Range(this.start + n, this.length);
    }

    @Override
    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        return this.length == 0;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.start + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getLastIndex() {
        return this.start + this.length - 1;
    }

    @Override
    public boolean contains(int i) {
        return this.getStart() <= i && i < this.getStart() + this.getLength();
    }

    @Override
    public boolean contains(Range range) {
        return this.contains(range.getStart()) && this.contains(range.getEnd() - 1);
    }

    public boolean subset(Range range) {
        return range.contains(this);
    }

    public Range extend(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("i < 0");
        }
        if (this == EMPTY) {
            return new Range(i);
        }
        if (this.start == i + 1) {
            return new Range(this.start - 1, this.length + 1);
        }
        if (this.start + this.length == i) {
            return new Range(this.start, this.length + 1);
        }
        throw new IllegalArgumentException("i must border range: " + i);
    }

    public static Range getLeft(Range range1, Range range2) {
        if (range1.getStart() <= range2.getStart()) {
            return range1;
        }
        return range2;
    }

    public static Range getRight(Range range1, Range range2) {
        if (range1.getStart() > range2.getStart()) {
            return range1;
        }
        return range2;
    }

    public boolean overlapsWith(Range range) {
        if (this.isEmpty() || range.isEmpty()) {
            return false;
        }
        Range left = Range.getLeft(this, range);
        Range right = Range.getRight(this, range);
        return left.getStart() <= right.getStart() && right.getStart() < left.getStart() + left.getLength();
    }

    public int overlap(Range range) {
        Range right;
        if (this.isEmpty() || range.isEmpty() || !this.overlapsWith(range)) {
            return 0;
        }
        Range left = Range.getLeft(this, range);
        Range range2 = right = this.getEnd() > range.getEnd() ? this : range;
        if (left.equals(right)) {
            return left == this ? range.size() : this.size();
        }
        return Math.max(0, left.getEnd() - right.getStart());
    }

    public boolean isAdjacentTo(Range range) {
        Range left = Range.getLeft(this, range);
        Range right = Range.getRight(this, range);
        return left.getEnd() == right.getStart();
    }

    public boolean isAdjacentOrOverlaps(Range range) {
        return this.isAdjacentTo(range) || this.overlapsWith(range);
    }

    public Range join(Range range) {
        if (range.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return range;
        }
        if (this.isAdjacentOrOverlaps(range)) {
            int start = Range.getLeft(this, range).getStart();
            int length = Math.max(this.getLastIndex(), range.getLastIndex()) + 1 - start;
            return new Range(start, length);
        }
        throw new IllegalArgumentException("Ranges must be adjacent or overlapping to merge.");
    }

    public Range extend(Range range) {
        if (range.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return range;
        }
        int start = Range.getLeft(this, range).getStart();
        int end = Range.getRight(this, range).getEnd();
        return Range.fromInterval(start, end);
    }

    public Range removeOverlap(Range range) {
        Integer newStart = -1;
        Integer newLength = 0;
        for (int i = this.getStart(); !(i >= this.getStart() + this.getLength() || range.contains(i) && newStart >= 0); ++i) {
            if (!range.contains(i) && newStart == -1) {
                newStart = i;
                newLength = 1;
                continue;
            }
            if (range.contains(i) || newStart < 0) continue;
            Integer n = newLength;
            Integer n2 = newLength = Integer.valueOf(newLength + 1);
        }
        if (newStart < 0) {
            return null;
        }
        return new Range(newStart, newLength);
    }

    public boolean equals(Range r) {
        return r.getStart() == this.getStart() && r.getLength() == this.getLength();
    }

    public String toString() {
        return "[" + this.start + ", " + this.getEnd() + ")";
    }

    public String toString(List<Object> parts) {
        return Joiner.on((String)", ").join(parts.subList(this.getStart(), this.getEnd()), (Object)", ", new Object[0]);
    }

    public static Comparator<Range> getStartComparator() {
        return startComparator;
    }

    public static int compareStarts(Range r1, Range r2) {
        return startComparator.compare(r1, r2);
    }

    public static boolean isDisjoint(Collection<Range> ranges) {
        ArrayList<Range> rangesList = new ArrayList<Range>(ranges.size());
        rangesList.addAll(ranges);
        Collections.sort(rangesList);
        for (int i = 0; i < rangesList.size() - 1; ++i) {
            Range rNext;
            Range rCurrent = (Range)rangesList.get(i);
            if (!rCurrent.overlapsWith(rNext = (Range)rangesList.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.start == other.start;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RangeIterator(this);
    }

    @Override
    public int compareTo(Range o) {
        return startComparator.compare(this, o);
    }

    private class RangeIterator
    implements Iterator<Integer> {
        private final int start;
        private final int length;
        private int i;

        public RangeIterator(int start, int length) {
            this.start = start;
            this.length = length;
            this.i = start;
        }

        public RangeIterator(Range r) {
            this(r.getStart(), r.getLength());
        }

        @Override
        public boolean hasNext() {
            return this.i < this.start + this.length;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                return this.i++;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

