/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static String getExtension(File f) {
        String ext = null;
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            ext = name.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void pipe(Reader reader, Writer writer) throws IOException {
        FileUtils.pipe(reader, writer, 4092);
    }

    public static void pipe(Reader reader, Writer writer, int buffersize) throws IOException {
        char[] buffer = new char[buffersize];
        while (reader.read(buffer) != -1) {
            writer.write(buffer);
        }
    }

    public static void pipe(InputStream is, OutputStream os) throws IOException {
        FileUtils.pipe(is, os, 4092);
    }

    public static void pipe(InputStream is, OutputStream os, int buffersize) throws IOException {
        byte[] buffer = new byte[buffersize];
        while (is.read(buffer) != -1) {
            os.write(buffer);
        }
    }

    public static ArrayList<File> find(File path, Boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.find(files, path, recursive);
        return files;
    }

    private static void find(List<File> files, File path, Boolean recursive) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (!recursive.booleanValue() && file.isDirectory()) continue;
                FileUtils.find(files, file, recursive);
            }
        } else {
            files.add(path);
        }
    }
}

