/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.commonlib;

public class ComparableSequence<E extends Comparable<E>>
implements Comparable<ComparableSequence<E>> {
    private final E[] comparables;

    public ComparableSequence(E[] comparables) {
        this.comparables = comparables;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ComparableSequence)) {
            return false;
        }
        ComparableSequence comperable = (ComparableSequence)other;
        return this.compareTo(comperable) == 0;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.comparables.length; ++i) {
            hash *= this.comparables[i].hashCode();
            hash *= 39;
        }
        return hash;
    }

    @Override
    public int compareTo(ComparableSequence<E> comparable) {
        return this.compareTo(comparable, 0);
    }

    public int compareTo(ComparableSequence<E> comparable, int index) {
        int compare = this.comparables[index].compareTo(comparable.comparables[index]);
        if (compare == 0) {
            if (index == this.comparables.length - 1) {
                return 0;
            }
            return this.compareTo(comparable, index + 1);
        }
        return compare;
    }
}

