/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.util.Date;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakUtil;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;

public final class GempakLookup
implements GridTableLookup {
    private GempakGridRecord sample;

    public GempakLookup(GempakGridRecord sample) {
        this.sample = sample;
    }

    @Override
    public String getShapeName(GridDefRecord gds) {
        return "Spherical";
    }

    @Override
    public final String getGridName(GridDefRecord gds) {
        return this.getProjectionName(gds);
    }

    @Override
    public final GridParameter getParameter(GridRecord gr) {
        String name = gr.getParameterName();
        GempakParameter gp = GempakGridParameterTable.getParameter(name);
        if (gp != null) {
            return gp;
        }
        return new GridParameter(0, name, name, "");
    }

    @Override
    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    @Override
    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    @Override
    public final String getLevelName(GridRecord gr) {
        return GempakUtil.LV_CCRD(gr.getLevelType1());
    }

    @Override
    public final String getLevelDescription(GridRecord gr) {
        String levelName;
        switch (levelName = this.getLevelName(gr)) {
            case "PRES": {
                return "pressure";
            }
            case "NONE": {
                return "surface";
            }
            case "HGHT": {
                return "height_above_ground";
            }
            case "THTA": {
                return "isentropic";
            }
            case "SGMA": {
                return "sigma";
            }
            case "DPTH": {
                return "depth";
            }
            case "PDLY": {
                return "layer_between_two_pressure_difference_from_ground";
            }
            case "FRZL": {
                return "zeroDegC_isotherm";
            }
            case "TROP": {
                return "tropopause";
            }
            case "CLDL": {
                return "cloud_base";
            }
            case "CLDT": {
                return "cloud_tops";
            }
            case "MWSL": {
                return "maximum_wind_level";
            }
        }
        return levelName;
    }

    @Override
    public final String getLevelUnit(GridRecord gr) {
        String levelName;
        switch (levelName = this.getLevelName(gr)) {
            case "PRES": {
                return "hPa";
            }
            case "HGHT": {
                return "m";
            }
            case "THTA": {
                return "K";
            }
            case "SGMA": {
                return "";
            }
            case "DPTH": {
                return "m";
            }
            case "PDLY": {
                return "hPa";
            }
        }
        return "";
    }

    @Override
    public final String getTimeRangeUnitName(int tunit) {
        return "minute";
    }

    @Override
    public final Date getFirstBaseTime() {
        return this.sample.getReferenceTime();
    }

    @Override
    public final boolean isLatLon(GridDefRecord gds) {
        return this.getProjectionName(gds).equals("CED");
    }

    @Override
    public final int getProjectionType(GridDefRecord gds) {
        String name;
        switch (name = this.getProjectionName(gds).trim()) {
            case "CED": {
                return -1;
            }
            case "MER": {
                return 3;
            }
            case "MCD": {
                return 3;
            }
            case "LCC": {
                return 2;
            }
            case "SCC": {
                return 2;
            }
            case "PS": {
                return 1;
            }
            case "STR": {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public final boolean isVerticalCoordinate(GridRecord gr) {
        int type = gr.getLevelType1();
        return type > GempakUtil.vertCoords.length || !GempakUtil.vertCoords[type].equals("NONE");
    }

    @Override
    public final boolean isPositiveUp(GridRecord gr) {
        int type = gr.getLevelType1();
        return type != 1 && type != 5;
    }

    @Override
    public final float getFirstMissingValue() {
        return -9999.0f;
    }

    @Override
    public boolean isLayer(GridRecord gr) {
        return gr.getLevel2() != -1.0;
    }

    private String getProjectionName(GridDefRecord gds) {
        return gds.getParam("ProjFlag");
    }

    @Override
    public final String getTitle() {
        return "GRID data";
    }

    @Override
    public String getInstitution() {
        return null;
    }

    @Override
    public final String getSource() {
        return null;
    }

    @Override
    public final String getComment() {
        return null;
    }

    @Override
    public String getGridType() {
        return "GEMPAK";
    }
}

