/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.unidata.util.StringUtil2;

public class Grib1ParamTableReader {
    private static final Logger logger = LoggerFactory.getLogger(Grib1ParamTableReader.class);
    private static final boolean debug = false;
    private int center_id;
    private int subcenter_id;
    private int version;
    private final String name;
    private String path;
    private String desc;
    private Map<Integer, Grib1Parameter> parameters;
    private boolean useName;
    private static final Pattern nclPattern = Pattern.compile("\\{(\\d*),\\s*\"([^\"]*)\",\\s*\"([^\"]*)\",\\s*\"([^\"]*)\".*");

    public Grib1ParamTableReader(String path) {
        this.path = StringUtil2.replace(path, "\\", "/");
        File f = new File(path);
        this.name = f.getName();
        this.parameters = this.readParameterTable();
    }

    Grib1ParamTableReader(int center_id, int subcenter_id, int version, String path) {
        this.center_id = center_id;
        this.subcenter_id = subcenter_id;
        this.version = version;
        this.path = StringUtil2.replace(path, "\\", "/");
        File f = new File(path);
        this.name = f.getName();
    }

    Grib1ParamTableReader(Element paramTableElem) {
        this.name = paramTableElem.getChildText("title");
        DssParser p = new DssParser(Catalog.ncmlNS);
        this.parameters = p.parseXml(paramTableElem);
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean useParamName() {
        return this.useName;
    }

    public int getKey() {
        return Grib1ParamTables.makeKey(this.center_id, this.subcenter_id, this.version);
    }

    public String getPath() {
        return this.path;
    }

    public Map<Integer, Grib1Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters;
    }

    public void setParameters(Map<Integer, Grib1Parameter> params) {
        this.parameters = params;
    }

    public Grib1Parameter getParameter(int id) {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public Grib1Parameter getLocalParameter(int id) {
        if (this.parameters == null) {
            this.parameters = this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public String toString() {
        return "Grib1ParamTable{center_id=" + this.center_id + ", subcenter_id=" + this.subcenter_id + ", version=" + this.version + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private synchronized Map<Integer, Grib1Parameter> readParameterTable() {
        if (this.path == null) {
            throw new IllegalStateException(this.name);
        }
        try {
            if (this.name.startsWith("table_2_") || this.name.startsWith("local_table_2_")) {
                return this.readParameterTableEcmwf();
            }
            if (this.name.startsWith("US058")) {
                return this.readParameterTableXml(new FnmocParser());
            }
            if (this.name.endsWith(".tab")) {
                return this.readParameterTableTab();
            }
            if (this.name.endsWith(".wrf")) {
                return this.readParameterTableSplit("\\|", new int[]{0, 3, 1, 2});
            }
            if (this.name.endsWith(".h")) {
                return this.readParameterTableNcl();
            }
            if (this.name.endsWith(".dss")) {
                return this.readParameterTableSplit("\t", new int[]{0, -1, 1, 2});
            }
            if (this.name.endsWith(".xml")) {
                return this.readParameterTableXml(new DssParser(Namespace.NO_NAMESPACE));
            }
            if (this.name.startsWith("2.98")) {
                return this.readParameterTableEcmwfEcCodes();
            }
            throw new RuntimeException("Grib1ParamTableReader: Dont know how to read " + this.name + " file=" + this.path);
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table {}:{}", (Object)this.path, (Object)ioError.getMessage());
            throw new RuntimeException(ioError);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<Integer, Grib1Parameter> readParameterTableNcl() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int extract(String line, String key) {
        int pos = line.indexOf(key);
        if (pos < 0) {
            return -1;
        }
        String want = line.substring(pos + key.length());
        try {
            return Integer.parseInt(want.trim());
        }
        catch (NumberFormatException e) {
            logger.warn("BAD {} ({})", (Object)line, (Object)this.path);
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    private Map<Integer, Grib1Parameter> readParameterTableEcmwf() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<Integer, Grib1Parameter> readParameterTableEcmwfEcCodes() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, Grib1Parameter> readParameterTableXml(XmlTableParser parser) throws IOException {
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            Map<Integer, Grib1Parameter> map = parser.parseXml(root);
            return map;
        }
        catch (IOException | JDOMException e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<Integer, Grib1Parameter> readParameterTableSplit(String regexp, int[] order) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Integer, Grib1Parameter> readParameterTableTab() throws IOException {
        try (InputStream is = GribResourceReader.getInputStream(this.path);){
            HashMap<Integer, Grib1Parameter> params;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                br.readLine();
                params = new HashMap<Integer, Grib1Parameter>();
                while ((line = br.readLine()) != null) {
                    String units;
                    String desc;
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    String[] tableDefArr = line.split(":");
                    int p1 = Integer.parseInt(tableDefArr[0].trim());
                    String name = tableDefArr[1].trim();
                    if (tableDefArr[2].indexOf(91) == -1) {
                        desc = tableDefArr[2].trim();
                        units = "";
                    } else {
                        String[] arr2 = tableDefArr[2].split("\\[");
                        desc = arr2[0].trim();
                        units = arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim();
                    }
                    Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units);
                    if (!parameter.getDescription().equalsIgnoreCase("undefined")) {
                        params.put(parameter.getNumber(), parameter);
                    }
                    logger.debug(parameter.getNumber() + " " + parameter.getDescription() + " " + parameter.getUnit());
                }
            }
            Map<Integer, Grib1Parameter> map = Collections.unmodifiableMap(params);
            return map;
        }
    }

    private class FnmocParser
    implements XmlTableParser {
        private FnmocParser() {
        }

        public HashMap<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code;
                try {
                    code = Integer.parseInt(elem1.getChildText("grib1Id"));
                }
                catch (NumberFormatException e) {
                    logger.warn("BAD number= {}", (Object)elem1.getChildText("grib1Id"));
                    continue;
                }
                String desc = elem1.getChildText("description");
                if (desc == null) continue;
                desc = StringUtil2.collapseWhitespace(desc);
                String units = elem1.getChildText("unitsFNMOC");
                if (units == null) {
                    units = "";
                }
                String name = elem1.getChildText("name");
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTableReader.this, code, name, desc, units, null);
                result.put(parameter.getNumber(), parameter);
                logger.debug(" {}", (Object)parameter);
            }
            Grib1ParamTableReader.this.useName = true;
            return result;
        }
    }

    private class DssParser
    implements XmlTableParser {
        private final Namespace ns;

        DssParser(Namespace ns) {
            this.ns = ns;
        }

        @Override
        public Map<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            List<Element> params = root.getChildren("parameter", this.ns);
            for (Element elem1 : params) {
                String name;
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description", this.ns);
                if (desc == null) continue;
                String units = elem1.getChildText("units", this.ns);
                if (units == null) {
                    units = "";
                }
                if ((name = elem1.getChildText("name", this.ns)) == null) {
                    name = elem1.getChildText("shortName", this.ns);
                }
                String cf = elem1.getChildText("CF", this.ns);
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTableReader.this, code, name, desc, units, cf);
                result.put(parameter.getNumber(), parameter);
                logger.debug(" {}", (Object)parameter);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private static interface XmlTableParser {
        public Map<Integer, Grib1Parameter> parseXml(Element var1);
    }
}

