/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.CalibratorGvar;

public class CalibratorGvarG9
extends CalibratorGvar {
    protected static float[] imager9FK1 = new float[5];
    protected static float[] sounder9FK1 = new float[18];
    protected static float[] imager9FK2 = new float[5];
    protected static float[] sounder9FK2 = new float[18];
    protected static float[] imager9TC1 = new float[5];
    protected static float[] sounder9TC1 = new float[18];
    protected static float[] imager9TC2 = new float[5];
    protected static float[] sounder9TC2 = new float[18];

    public CalibratorGvarG9(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG9(int id, int[] cal) {
        super(id, cal);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager9FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager9FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager9TC1[band - 1]) / (double)imager9TC2[band - 1]);
        } else {
            double expn = (double)(sounder9FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder9FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder9TC1[band - 1]) / (double)sounder9TC2[band - 1]);
        }
        return outVal;
    }

    static {
        CalibratorGvarG9.imager9FK1[0] = 0.0f;
        CalibratorGvarG9.imager9FK1[1] = 198807.8f;
        CalibratorGvarG9.imager9FK1[2] = 38732.41f;
        CalibratorGvarG9.imager9FK1[3] = 9717.21f;
        CalibratorGvarG9.imager9FK1[4] = 6899.47f;
        CalibratorGvarG9.sounder9FK1[0] = 3765.12f;
        CalibratorGvarG9.sounder9FK1[1] = 3981.16f;
        CalibratorGvarG9.sounder9FK1[2] = 4281.88f;
        CalibratorGvarG9.sounder9FK1[3] = 4678.91f;
        CalibratorGvarG9.sounder9FK1[4] = 4962.59f;
        CalibratorGvarG9.sounder9FK1[5] = 5860.42f;
        CalibratorGvarG9.sounder9FK1[6] = 6770.32f;
        CalibratorGvarG9.sounder9FK1[7] = 8958.91f;
        CalibratorGvarG9.sounder9FK1[8] = 12965.93f;
        CalibratorGvarG9.sounder9FK1[9] = 28398.28f;
        CalibratorGvarG9.sounder9FK1[10] = 34201.34f;
        CalibratorGvarG9.sounder9FK1[11] = 42525.14f;
        CalibratorGvarG9.sounder9FK1[12] = 124057.4f;
        CalibratorGvarG9.sounder9FK1[13] = 128011.4f;
        CalibratorGvarG9.sounder9FK1[14] = 134849.7f;
        CalibratorGvarG9.sounder9FK1[15] = 167814.2f;
        CalibratorGvarG9.sounder9FK1[16] = 188801.2f;
        CalibratorGvarG9.sounder9FK1[17] = 225856.5f;
        CalibratorGvarG9.imager9FK2[0] = 0.0f;
        CalibratorGvarG9.imager9FK2[1] = 3677.02f;
        CalibratorGvarG9.imager9FK2[2] = 2131.62f;
        CalibratorGvarG9.imager9FK2[3] = 1344.41f;
        CalibratorGvarG9.imager9FK2[4] = 1199.38f;
        CalibratorGvarG9.sounder9FK2[0] = 980.12f;
        CalibratorGvarG9.sounder9FK2[1] = 998.52f;
        CalibratorGvarG9.sounder9FK2[2] = 1023.05f;
        CalibratorGvarG9.sounder9FK2[3] = 1053.74f;
        CalibratorGvarG9.sounder9FK2[4] = 1074.62f;
        CalibratorGvarG9.sounder9FK2[5] = 1135.87f;
        CalibratorGvarG9.sounder9FK2[6] = 1191.85f;
        CalibratorGvarG9.sounder9FK2[7] = 1308.49f;
        CalibratorGvarG9.sounder9FK2[8] = 1480.08f;
        CalibratorGvarG9.sounder9FK2[9] = 1922.13f;
        CalibratorGvarG9.sounder9FK2[10] = 2045.03f;
        CalibratorGvarG9.sounder9FK2[11] = 2199.04f;
        CalibratorGvarG9.sounder9FK2[12] = 3142.14f;
        CalibratorGvarG9.sounder9FK2[13] = 3175.18f;
        CalibratorGvarG9.sounder9FK2[14] = 3230.74f;
        CalibratorGvarG9.sounder9FK2[15] = 3475.05f;
        CalibratorGvarG9.sounder9FK2[16] = 3614.26f;
        CalibratorGvarG9.sounder9FK2[17] = 3836.74f;
        CalibratorGvarG9.imager9TC1[0] = 0.0f;
        CalibratorGvarG9.imager9TC1[1] = 0.5864f;
        CalibratorGvarG9.imager9TC1[2] = 0.4841f;
        CalibratorGvarG9.imager9TC1[3] = 0.3622f;
        CalibratorGvarG9.imager9TC1[4] = 0.2014f;
        CalibratorGvarG9.sounder9TC1[0] = 0.0099f;
        CalibratorGvarG9.sounder9TC1[1] = 0.0119f;
        CalibratorGvarG9.sounder9TC1[2] = 0.0122f;
        CalibratorGvarG9.sounder9TC1[3] = 0.0119f;
        CalibratorGvarG9.sounder9TC1[4] = 0.0135f;
        CalibratorGvarG9.sounder9TC1[5] = 0.044f;
        CalibratorGvarG9.sounder9TC1[6] = 0.1345f;
        CalibratorGvarG9.sounder9TC1[7] = 0.1193f;
        CalibratorGvarG9.sounder9TC1[8] = 0.0407f;
        CalibratorGvarG9.sounder9TC1[9] = 0.1438f;
        CalibratorGvarG9.sounder9TC1[10] = 0.2762f;
        CalibratorGvarG9.sounder9TC1[11] = 0.137f;
        CalibratorGvarG9.sounder9TC1[12] = 0.0189f;
        CalibratorGvarG9.sounder9TC1[13] = 0.0198f;
        CalibratorGvarG9.sounder9TC1[14] = 0.0191f;
        CalibratorGvarG9.sounder9TC1[15] = 0.0531f;
        CalibratorGvarG9.sounder9TC1[16] = 0.0612f;
        CalibratorGvarG9.sounder9TC1[17] = 0.3042f;
        CalibratorGvarG9.imager9TC2[0] = 0.0f;
        CalibratorGvarG9.imager9TC2[1] = 0.9992f;
        CalibratorGvarG9.imager9TC2[2] = 0.9989f;
        CalibratorGvarG9.imager9TC2[3] = 0.9988f;
        CalibratorGvarG9.imager9TC2[4] = 0.9992f;
        CalibratorGvarG9.sounder9TC2[0] = 1.0f;
        CalibratorGvarG9.sounder9TC2[1] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[2] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[3] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[4] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[5] = 0.9998f;
        CalibratorGvarG9.sounder9TC2[6] = 0.9995f;
        CalibratorGvarG9.sounder9TC2[7] = 0.9996f;
        CalibratorGvarG9.sounder9TC2[8] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[9] = 0.9996f;
        CalibratorGvarG9.sounder9TC2[10] = 0.9993f;
        CalibratorGvarG9.sounder9TC2[11] = 0.9997f;
        CalibratorGvarG9.sounder9TC2[12] = 1.0f;
        CalibratorGvarG9.sounder9TC2[13] = 1.0f;
        CalibratorGvarG9.sounder9TC2[14] = 1.0f;
        CalibratorGvarG9.sounder9TC2[15] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[16] = 0.9999f;
        CalibratorGvarG9.sounder9TC2[17] = 0.9996f;
    }
}

