/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import ucar.mcidas.Calibrator;
import ucar.mcidas.CalibratorException;
import ucar.mcidas.CalibratorGvarG10;
import ucar.mcidas.CalibratorGvarG12;
import ucar.mcidas.CalibratorGvarG13;
import ucar.mcidas.CalibratorGvarG14;
import ucar.mcidas.CalibratorGvarG15;
import ucar.mcidas.CalibratorGvarG8;
import ucar.mcidas.CalibratorGvarG9;
import ucar.mcidas.CalibratorMsg;

public final class CalibratorFactory {
    private CalibratorFactory() {
    }

    public static final Calibrator getCalibrator(int id, int[] cal) throws CalibratorException {
        return CalibratorFactory.getCalibrator(id, 1, cal);
    }

    public static final Calibrator getCalibrator(int id, int srcType, int[] cal) throws CalibratorException {
        Calibrator calibrator = null;
        switch (id) {
            case 51: 
            case 52: 
            case 53: {
                calibrator = new CalibratorMsg(cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 70: 
            case 71: {
                calibrator = new CalibratorGvarG8(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 72: 
            case 73: {
                calibrator = new CalibratorGvarG9(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 74: 
            case 75: {
                calibrator = new CalibratorGvarG10(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 78: 
            case 79: {
                calibrator = new CalibratorGvarG12(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 180: 
            case 181: {
                calibrator = new CalibratorGvarG13(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 182: 
            case 183: {
                calibrator = new CalibratorGvarG14(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            case 184: 
            case 185: {
                calibrator = new CalibratorGvarG15(id, cal);
                calibrator.setCalType(srcType);
                break;
            }
            default: {
                throw new CalibratorException("Unknown or unimplemented sensor id: " + id);
            }
        }
        return calibrator;
    }

    public static final boolean hasCalibrator(int id) {
        switch (id) {
            case 51: 
            case 52: 
            case 53: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return true;
            }
        }
        return false;
    }
}

