/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridRecord;

public final class GridIndex {
    public static final String current_index_version = "8.0";
    public final String filename;
    private final List<GridRecord> index = new ArrayList<GridRecord>();
    private final List<GridDefRecord> gcs = new ArrayList<GridDefRecord>();
    private final Map<String, String> atts = new HashMap<String, String>();

    public GridIndex(String filename) {
        this.filename = filename;
    }

    public final Map<String, String> getGlobalAttributes() {
        return this.atts;
    }

    public final List<GridRecord> getGridRecords() {
        return this.index;
    }

    public final List<GridDefRecord> getHorizCoordSys() {
        return this.gcs;
    }

    public final void addGridRecord(GridRecord gr) {
        this.index.add(gr);
    }

    public final void addHorizCoordSys(GridDefRecord gds) {
        this.gcs.add(gds);
    }

    public final void addGlobalAttribute(String name, String value) {
        this.atts.put(name, value);
    }

    public int getGridCount() {
        return this.index.size();
    }

    public void finish() {
        if (this.gcs.size() == 1) {
            return;
        }
        if (this.gcs.size() == 2) {
            List<GridDefRecord> hcs = this.getHorizCoordSys();
            GridDefRecord.compare(hcs.get(0), hcs.get(1));
        }
    }
}

