/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.internal.iosp.netcdf3.N3headerNew;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutRegularSegmented;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class N3iospNew
extends AbstractIOServiceProvider
implements IOServiceProvider {
    private static Logger log = LoggerFactory.getLogger(N3iospNew.class);
    protected N3headerNew header;
    protected long lastModified;
    protected boolean debug;
    protected boolean debugRecord;
    protected boolean debugRead;
    private Charset valueCharset;
    protected boolean useRecordStructure;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return N3headerNew.isValidFile(raf);
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        try {
            this.header.showDetail(f);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return f.toString();
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File file;
        super.open(raf, ncfile, cancelTask);
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = this.createHeader();
        Group.Builder rootGroup = Group.builder(null).setName("").setNcfile(ncfile);
        this.header.read(raf, rootGroup, null);
        ncfile.setRootGroup(rootGroup.build(null));
        ncfile.finish();
    }

    @Override
    public boolean isBuilder() {
        return true;
    }

    @Override
    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        File file;
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = this.createHeader();
        this.header.read(raf, rootGroup, null);
    }

    protected N3headerNew createHeader() {
        return new N3headerNew(this);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Layout layout;
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section);
        }
        N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout2 = layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        if (layout.getTotalNelems() == 0L) {
            return Array.factory(dataType, section.getShape());
        }
        Object data = this.readData(layout, dataType);
        return Array.factory(dataType, section.getShape(), data);
    }

    private Array readRecordData(Structure s2, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        StructureMembers members = s2.makeStructureMembers();
        for (StructureMembers.Member m3 : members.getMembers()) {
            Variable v2 = s2.findVariable(m3.getName());
            N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
            m3.setDataParam((int)(vinfo.begin - this.header.recStart));
        }
        if (this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cant read records when recsize > 2147483647");
        }
        long nrecs = section.computeSize();
        if (nrecs * this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large read: nrecs * recsize= " + nrecs * this.header.recsize + "bytes exceeds " + Integer.MAX_VALUE);
        }
        members.setStructureSize((int)this.header.recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, new int[]{recordRange.length()});
        byte[] result = structureArray.getByteBuffer().array();
        int count = 0;
        for (int recnum : recordRange) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            if (recnum != this.header.numrecs - 1) {
                this.raf.readFully(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            } else {
                this.raf.read(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            }
            ++count;
        }
        return structureArray;
    }

    private Array readRecordDataSubset(Structure s2, Section section) {
        Range recordRange = section.getRange(0);
        int nrecords = recordRange.length();
        StructureMembers members = s2.makeStructureMembers();
        for (StructureMembers.Member m3 : members.getMembers()) {
            Variable v2 = s2.findVariable(m3.getName());
            N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
            m3.setDataParam((int)(vinfo.begin - this.header.recStart));
            int rank = m3.getShape().length;
            int[] fullShape = new int[rank + 1];
            fullShape[0] = nrecords;
            System.arraycopy(m3.getShape(), 0, fullShape, 1, rank);
            Array data = Array.factory(m3.getDataType(), fullShape);
            m3.setDataArray(data);
            m3.setDataObject(data.getIndexIterator());
        }
        return null;
    }

    private Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        int[] fullShape = new int[v2.getRank() + 1];
        fullShape[0] = this.header.numrecs;
        System.arraycopy(v2.getShape(), 0, fullShape, 1, v2.getRank());
        LayoutRegularSegmented layout = new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, fullShape, section);
        Object dataObject = this.readData(layout, dataType);
        return Array.factory(dataType, section.getShape(), dataObject);
    }

    @Override
    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section, channel);
        }
        N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        return this.readData(layout, dataType, channel);
    }

    private long readRecordData(Structure s2, Section section, WritableByteChannel out) throws IOException {
        long count = 0L;
        Range recordRange = section.getRange(0);
        for (int recnum : recordRange) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            count += this.raf.readToByteChannel(out, this.header.recStart + (long)recnum * this.header.recsize, this.header.recsize);
        }
        return count;
    }

    @Override
    public boolean syncExtend() throws IOException {
        return true;
    }

    public void flush() throws IOException {
        if (this.raf != null) {
            this.raf.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            long size = this.header.calcFileSize();
            this.raf.setMinLength(size);
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void reacquire() throws IOException {
        super.reacquire();
        this.header.raf = this.raf;
    }

    @Override
    public String toStringDebug(Object o) {
        return null;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message instanceof Charset) {
            this.setValueCharset((Charset)message);
        }
        if (null == this.header) {
            return null;
        }
        return super.sendIospMessage(message);
    }

    protected Optional<Charset> getValueCharset() {
        return Optional.ofNullable(this.valueCharset);
    }

    protected void setValueCharset(@Nullable Charset charset) {
        this.valueCharset = charset;
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.NETCDF.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "NetCDF-3/CDM";
    }

    protected Object readData(Layout index, DataType dataType) throws IOException {
        return IospHelper.readDataFill(this.raf, index, dataType, null, -1);
    }

    protected long readData(Layout index, DataType dataType, WritableByteChannel out) throws IOException {
        long count;
        block5: {
            block7: {
                block6: {
                    block4: {
                        count = 0L;
                        if (dataType.getPrimitiveClassType() != Byte.TYPE && dataType != DataType.CHAR) break block4;
                        while (index.hasNext()) {
                            Layout.Chunk chunk = index.next();
                            count += this.raf.readToByteChannel(out, chunk.getSrcPos(), chunk.getNelems());
                        }
                        break block5;
                    }
                    if (dataType.getPrimitiveClassType() != Short.TYPE) break block6;
                    while (index.hasNext()) {
                        Layout.Chunk chunk = index.next();
                        count += this.raf.readToByteChannel(out, chunk.getSrcPos(), 2 * chunk.getNelems());
                    }
                    break block5;
                }
                if (dataType.getPrimitiveClassType() != Integer.TYPE && dataType != DataType.FLOAT) break block7;
                while (index.hasNext()) {
                    Layout.Chunk chunk = index.next();
                    count += this.raf.readToByteChannel(out, chunk.getSrcPos(), 4 * chunk.getNelems());
                }
                break block5;
            }
            if (dataType != DataType.DOUBLE && dataType.getPrimitiveClassType() != Long.TYPE) break block5;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                count += this.raf.readToByteChannel(out, chunk.getSrcPos(), 8 * chunk.getNelems());
            }
        }
        return count;
    }
}

