/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.grib.grib2.table.WmoParamTable;

abstract class LocalTables
extends Grib2Tables {
    protected Map<Integer, Grib2Parameter> localParams = new HashMap<Integer, Grib2Parameter>();

    LocalTables(Grib2TableConfig config) {
        super(config);
    }

    @Override
    public String getParamTablePathUsedFor(int discipline, int category, int number) {
        return LocalTables.isLocal(discipline, category, number) ? super.getParamTablePathUsedFor(discipline, category, number) : this.config.getPath();
    }

    @Override
    public ImmutableList<GribTables.Parameter> getParameters() {
        return this.getLocalParameters();
    }

    protected ImmutableList<GribTables.Parameter> getLocalParameters() {
        return this.localParams.values().stream().sorted(new ParameterSort()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public String getVariableName(int discipline, int category, int number) {
        if (LocalTables.isLocal(discipline, category, number)) {
            return super.getVariableName(discipline, category, number);
        }
        GribTables.Parameter te = this.getParameter(discipline, category, number);
        if (te == null) {
            return super.getVariableName(discipline, category, number);
        }
        return te.getName();
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        Grib2Parameter plocal = this.localParams.get(LocalTables.makeParamId(discipline, category, number));
        if (LocalTables.isLocal(discipline, category, number)) {
            GribTables.Parameter pwmo = WmoParamTable.getParameter(discipline, category, number);
            if (plocal == null) {
                return pwmo;
            }
            if (pwmo == null) {
                return plocal;
            }
            return new Grib2Parameter(plocal, pwmo.getName(), pwmo.getUnit());
        }
        return plocal;
    }

    @Override
    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return this.localParams.get(LocalTables.makeParamId(discipline, category, number));
    }

    protected static class ParameterSort
    implements Comparator<GribTables.Parameter> {
        protected ParameterSort() {
        }

        @Override
        public int compare(GribTables.Parameter p1, GribTables.Parameter p2) {
            int c = p1.getDiscipline() - p2.getDiscipline();
            if (c != 0) {
                return c;
            }
            c = p1.getCategory() - p2.getCategory();
            if (c != 0) {
                return c;
            }
            return p1.getNumber() - p2.getNumber();
        }
    }
}

