/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.NCdumpW;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder;
import ucar.nc2.ft2.coverage.adapter.GeoGridCoordinate2D;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class DtCoverageCS {
    protected DtCoverageCSBuilder builder;
    private String name;
    private ProjectionImpl proj;
    private GeoGridCoordinate2D g2d;
    private boolean isLatLon;
    private String horizStaggerType;
    private ProjectionRect mapArea;
    private LatLonRect llbb;

    public DtCoverageCS(DtCoverageCSBuilder builder) {
        this.builder = builder;
        this.name = CoordinateSystem.makeName(builder.allAxes);
        Attribute att = this.getXHorizAxis().findAttribute("_CoordinateStagger");
        if (att != null) {
            this.setHorizStaggerType(att.getStringValue());
        }
        if (builder.orgProj != null) {
            this.proj = builder.orgProj.constructCopy();
        }
    }

    public String getName() {
        return this.name;
    }

    public FeatureType getCoverageType() {
        return this.builder.type;
    }

    public List<CoordinateAxis> getCoordAxes() {
        return this.builder.allAxes;
    }

    public CoordinateAxis findCoordAxis(String shortName) {
        for (CoordinateAxis axis : this.builder.allAxes) {
            if (!axis.getShortName().equals(shortName)) continue;
            return axis;
        }
        return null;
    }

    public List<CoordinateTransform> getCoordTransforms() {
        return this.builder.coordTransforms;
    }

    public CoordinateAxis getXHorizAxis() {
        return this.builder.xaxis;
    }

    public CoordinateAxis getYHorizAxis() {
        return this.builder.yaxis;
    }

    public CoordinateAxis1D getVerticalAxis() {
        return this.builder.vertAxis;
    }

    public CoordinateAxis getTimeAxis() {
        return this.builder.timeAxis;
    }

    public CoordinateAxis1DTime getRunTimeAxis() {
        return this.builder.rtAxis;
    }

    public CoordinateAxis1D getEnsembleAxis() {
        return this.builder.ensAxis;
    }

    public ProjectionImpl getProjection() {
        return this.proj;
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public boolean isGlobalLon() {
        if (!this.isLatLon) {
            return false;
        }
        if (!(this.getXHorizAxis() instanceof CoordinateAxis1D)) {
            return false;
        }
        CoordinateAxis1D lon = (CoordinateAxis1D)this.getXHorizAxis();
        double first = lon.getCoordEdge(0);
        double last = lon.getCoordEdge((int)lon.getSize());
        double min2 = Math.min(first, last);
        double max = Math.max(first, last);
        return max - min2 >= 360.0;
    }

    public boolean isRegularSpatial() {
        if (!this.isRegularSpatial(this.getXHorizAxis())) {
            return false;
        }
        return this.isRegularSpatial(this.getYHorizAxis());
    }

    private boolean isRegularSpatial(CoordinateAxis axis) {
        if (axis == null) {
            return true;
        }
        if (!(axis instanceof CoordinateAxis1D)) {
            return false;
        }
        return ((CoordinateAxis1D)axis).isRegular();
    }

    public String getHorizStaggerType() {
        return this.horizStaggerType;
    }

    public void setHorizStaggerType(String horizStaggerType) {
        this.horizStaggerType = horizStaggerType;
    }

    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            CoordinateAxis horizXaxis = this.getXHorizAxis();
            CoordinateAxis horizYaxis = this.getYHorizAxis();
            if (horizXaxis == null || !horizXaxis.isNumeric() || horizYaxis == null || !horizYaxis.isNumeric()) {
                return null;
            }
            if (horizXaxis instanceof CoordinateAxis2D && horizYaxis instanceof CoordinateAxis2D) {
                CoordinateAxis2D xaxis2 = (CoordinateAxis2D)horizXaxis;
                CoordinateAxis2D yaxis2 = (CoordinateAxis2D)horizYaxis;
                this.mapArea = null;
            } else {
                CoordinateAxis1D xaxis1 = (CoordinateAxis1D)horizXaxis;
                CoordinateAxis1D yaxis1 = (CoordinateAxis1D)horizYaxis;
                this.mapArea = new ProjectionRect(xaxis1.getCoordEdge(0), yaxis1.getCoordEdge(0), xaxis1.getCoordEdge((int)xaxis1.getSize()), yaxis1.getCoordEdge((int)yaxis1.getSize()));
            }
        }
        return this.mapArea;
    }

    public LatLonPoint getLatLon(int xindex, int yindex) {
        double y;
        CoordinateAxis2D horiz2D;
        double x;
        CoordinateAxis1D horiz1D;
        CoordinateAxis horizXaxis = this.getXHorizAxis();
        CoordinateAxis horizYaxis = this.getYHorizAxis();
        if (horizXaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)horizXaxis;
            x = horiz1D.getCoordValue(xindex);
        } else {
            horiz2D = (CoordinateAxis2D)horizXaxis;
            x = horiz2D.getCoordValue(yindex, xindex);
        }
        if (horizYaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)horizYaxis;
            y = horiz1D.getCoordValue(yindex);
        } else {
            horiz2D = (CoordinateAxis2D)horizYaxis;
            y = horiz2D.getCoordValue(yindex, xindex);
        }
        return this.isLatLon() ? new LatLonPointImpl(y, x) : this.getLatLon(x, y);
    }

    public LatLonPoint getLatLon(double xcoord, double ycoord) {
        ProjectionImpl dataProjection = this.getProjection();
        return dataProjection.projToLatLon(new ProjectionPointImpl(xcoord, ycoord), new LatLonPointImpl());
    }

    public LatLonRect getLatLonBoundingBox() {
        if (this.llbb == null) {
            if (this.getXHorizAxis() instanceof CoordinateAxis2D && this.getYHorizAxis() instanceof CoordinateAxis2D) {
                return null;
            }
            CoordinateAxis horizXaxis = this.getXHorizAxis();
            CoordinateAxis horizYaxis = this.getYHorizAxis();
            if (this.isLatLon()) {
                double startLat = horizYaxis.getMinValue();
                double startLon = horizXaxis.getMinValue();
                double deltaLat = horizYaxis.getMaxValue() - startLat;
                double deltaLon = horizXaxis.getMaxValue() - startLon;
                LatLonPointImpl llpt = new LatLonPointImpl(startLat, startLon);
                this.llbb = new LatLonRect(llpt, deltaLat, deltaLon);
            } else {
                ProjectionImpl dataProjection = this.getProjection();
                ProjectionRect bb = this.getBoundingBox();
                if (bb != null) {
                    this.llbb = dataProjection.projToLatLonBB(bb);
                }
            }
        }
        return this.llbb;
    }

    public String toString() {
        Formatter buff = new Formatter();
        this.show(buff, false);
        return buff.toString();
    }

    public void show(Formatter f, boolean showCoords) {
        f.format("Coordinate System (%s)%n", this.getName());
        this.showCoordinateAxis(this.getRunTimeAxis(), f, showCoords);
        this.showCoordinateAxis(this.getEnsembleAxis(), f, showCoords);
        this.showCoordinateAxis(this.getTimeAxis(), f, showCoords);
        this.showCoordinateAxis(this.getVerticalAxis(), f, showCoords);
        this.showCoordinateAxis(this.getYHorizAxis(), f, showCoords);
        this.showCoordinateAxis(this.getXHorizAxis(), f, showCoords);
        if (this.proj != null) {
            f.format(" Projection: %s %s%n", this.proj.getName(), this.proj.paramsToString());
        }
    }

    private void showCoordinateAxis(CoordinateAxis axis, Formatter f, boolean showCoords) {
        if (axis == null) {
            return;
        }
        f.format(" rt=%s (%s)", axis.getNameAndDimensions(), axis.getClass().getName());
        if (showCoords) {
            this.showCoords(axis, f);
        }
        f.format("%n", new Object[0]);
    }

    private void showCoords(CoordinateAxis axis, Formatter f) {
        try {
            if (axis instanceof CoordinateAxis1D && axis.isNumeric()) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                if (!axis1D.isInterval()) {
                    double[] e;
                    for (double anE : e = axis1D.getCoordEdges()) {
                        f.format("%f,", anE);
                    }
                } else {
                    double[] b1 = axis1D.getBound1();
                    double[] b2 = axis1D.getBound2();
                    for (int i = 0; i < b1.length; ++i) {
                        f.format("(%f,%f) = %f%n", b1[i], b2[i], b2[i] - b1[i]);
                    }
                }
            } else {
                f.format("%s", NCdumpW.printVariableData(axis, null));
            }
        }
        catch (IOException ioe) {
            f.format(ioe.getMessage(), new Object[0]);
        }
        f.format(" %s%n", axis.getUnitsString());
    }

    public CalendarDateRange getCalendarDateRange() {
        CoordinateAxis timeTaxis = this.getTimeAxis();
        if (timeTaxis instanceof CoordinateAxis1DTime) {
            return ((CoordinateAxis1DTime)timeTaxis).getCalendarDateRange();
        }
        CoordinateAxis1DTime rtaxis = this.getRunTimeAxis();
        if (rtaxis != null) {
            return rtaxis.getCalendarDateRange();
        }
        return null;
    }

    public int getDomainRank() {
        return CoordinateSystem.makeDomain(this.builder.independentAxes).size();
    }

    public int getRangeRank() {
        return this.builder.allAxes.size();
    }
}

