/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.IndexIterator;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;

public class ImageArrayAdapter {
    public static BufferedImage makeGrayscaleImage(Array ma, IsMissingEvaluator missEval) {
        if (ma.getRank() < 2) {
            return null;
        }
        if (ma.getRank() == 3) {
            ma = ma.reduce();
        }
        if (ma.getRank() == 3) {
            ma = ma.slice(0, 0);
        }
        int h2 = ma.getShape()[0];
        int w = ma.getShape()[1];
        DataBuffer dataBuffer = ImageArrayAdapter.makeDataBuffer(ma, missEval);
        WritableRaster raster = WritableRaster.createInterleavedRaster(dataBuffer, w, h2, w, 1, new int[]{0}, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel colorModel = new ComponentColorModel(cs, new int[]{8}, false, false, 1, 0);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private static DataBuffer makeDataBuffer(Array ma, IsMissingEvaluator missEval) {
        if (ma instanceof ArrayByte) {
            return ImageArrayAdapter.makeByteDataBuffer((ArrayByte)ma);
        }
        MAMath.MinMax minmax = MAMath.getMinMaxSkipMissingData(ma, missEval);
        double diff = minmax.max - minmax.min;
        boolean hasMissing = missEval != null && missEval.hasMissing();
        int n = hasMissing ? 254 : 255;
        double scale = diff > 0.0 ? (double)n / diff : 1.0;
        IndexIterator ii = ma.getIndexIterator();
        int h2 = ma.getShape()[0];
        int w = ma.getShape()[1];
        byte[] byteData = new byte[h2 * w];
        for (int i = 0; i < byteData.length; ++i) {
            double val = ii.getDoubleNext();
            if (missEval != null && missEval.isMissing(val)) {
                byteData[i] = -1;
                continue;
            }
            double sval = (val - minmax.min) * scale;
            byteData[i] = (byte)sval;
        }
        return new DataBufferByte(byteData, byteData.length);
    }

    private static DataBuffer makeByteDataBuffer(ArrayByte ma) {
        byte[] byteData = (byte[])ma.copyTo1DJavaArray();
        return new DataBufferByte(byteData, byteData.length);
    }
}

