/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

public class ConversionUtility {
    public static float LatLonToDistance(float lat1, float lon1, float lat2, float lon2) {
        float r = 6371.0f;
        float z = (float)Math.PI / 180;
        double rlat = (double)lat1 * (double)z;
        double rlon = (double)lon1 * (double)z;
        double plat = (double)lat2 * (double)z;
        double plon = (double)lon2 * (double)z;
        double crlat = Math.cos(rlat);
        double crlon = Math.cos(rlon);
        double srlat = Math.sin(rlat);
        double srlon = Math.sin(rlon);
        double cplat = Math.cos(plat);
        double cplon = Math.cos(plon);
        double splat = Math.sin(plat);
        double splon = Math.sin(plon);
        double xx = cplat * cplon - crlat * crlon;
        double yy = cplat * splon - crlat * srlon;
        double zz = splat - srlat;
        double dist = Math.sqrt(xx * xx + yy * yy + zz * zz);
        double arcl = 2.0 * Math.asin(dist / 2.0) * (double)r;
        return (float)arcl;
    }

    public static float FloatLatLon(int dddmmss) {
        float negVal;
        int inVal;
        if (dddmmss < 0) {
            inVal = -dddmmss;
            negVal = -1.0f;
        } else {
            inVal = dddmmss;
            negVal = 1.0f;
        }
        float retVal = (float)(inVal / 10000) + (float)(inVal / 100 % 100) / 60.0f + (float)(inVal % 100) / 3600.0f;
        retVal = negVal * retVal;
        return retVal;
    }

    public static double GouldToNative(int inVal) {
        int sign = 1;
        if ((inVal & Integer.MIN_VALUE) != 0) {
            sign = -1;
            inVal = -inVal;
        }
        short byte0 = (short)(inVal & 0xFF);
        short byte1 = (short)(inVal >> 8 & 0xFF);
        short byte2 = (short)(inVal >> 16 & 0xFF);
        int exponent = (inVal & 0x7F000000) >> 24;
        if (exponent == 0) {
            exponent = 64;
        }
        float mant = byte0 + byte1 * 256 + byte2 * 65536;
        mant = Math.abs(mant);
        double dblMant = mant;
        double tempVal = Math.pow(16.0, 70 - exponent);
        double nativeVal = dblMant / tempVal;
        return nativeVal *= (double)sign;
    }

    public static void swap(int[] array, int first, int last) {
        for (int i = first; i <= last; ++i) {
            int k = array[i];
            array[i] = k >>> 24 & 0xFF | k >>> 8 & 0xFF00 | (k & 0xFF) << 24 | (k & 0xFF00) << 8;
        }
    }
}

