/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.fileformat.writer;

import java.io.IOException;
import ucar.jpeg.jj2000.j2k.fileformat.FileFormatBoxes;
import ucar.jpeg.jj2000.j2k.io.BEBufferedRandomAccessFile;

public class FileFormatWriter
implements FileFormatBoxes {
    private BEBufferedRandomAccessFile fi;
    private String filename;
    private int height;
    private int width;
    private int nc;
    private int[] bpc;
    private boolean bpcVaries;
    private int clength;
    private static final int CSB_LENGTH = 15;
    private static final int FTB_LENGTH = 20;
    private static final int IHB_LENGTH = 22;
    private static final int BPC_LENGTH = 8;

    public FileFormatWriter(String filename, int height, int width, int nc, int[] bpc, int clength) {
        this.height = height;
        this.width = width;
        this.nc = nc;
        this.bpc = bpc;
        this.filename = filename;
        this.clength = clength;
        this.bpcVaries = false;
        int fixbpc = bpc[0];
        for (int i = nc - 1; i > 0; --i) {
            if (bpc[i] == fixbpc) continue;
            this.bpcVaries = true;
        }
    }

    public int writeFileFormat() throws IOException {
        try {
            this.fi = new BEBufferedRandomAccessFile(this.filename, "rw+");
            byte[] codestream = new byte[this.clength];
            this.fi.readFully(codestream, 0, this.clength);
            this.fi.seek(0);
            this.fi.writeInt(12);
            this.fi.writeInt(1783636000);
            this.fi.writeInt(218793738);
            this.writeFileTypeBox();
            this.writeJP2HeaderBox();
            this.writeContiguousCodeStreamBox(codestream);
            this.fi.close();
        }
        catch (Exception e) {
            throw new Error("Error while writing JP2 file format");
        }
        if (this.bpcVaries) {
            return 85 + this.nc + 8;
        }
        return 85;
    }

    public void writeFileTypeBox() throws IOException {
        this.fi.writeInt(20);
        this.fi.writeInt(1718909296);
        this.fi.writeInt(1785737760);
        this.fi.writeInt(0);
        this.fi.writeInt(1785737760);
    }

    public void writeJP2HeaderBox() throws IOException {
        if (this.bpcVaries) {
            this.fi.writeInt(53 + this.nc);
        } else {
            this.fi.writeInt(45);
        }
        this.fi.writeInt(1785737832);
        this.writeImageHeaderBox();
        this.writeColourSpecificationBox();
        if (this.bpcVaries) {
            this.writeBitsPerComponentBox();
        }
    }

    public void writeBitsPerComponentBox() throws IOException {
        this.fi.writeInt(8 + this.nc);
        this.fi.writeInt(1651532643);
        for (int i = 0; i < this.nc; ++i) {
            this.fi.writeByte(this.bpc[i] - 1);
        }
    }

    public void writeColourSpecificationBox() throws IOException {
        this.fi.writeInt(15);
        this.fi.writeInt(1668246642);
        this.fi.writeByte(1);
        this.fi.writeByte(0);
        this.fi.writeByte(0);
        if (this.nc > 1) {
            this.fi.writeInt(16);
        } else {
            this.fi.writeInt(17);
        }
    }

    public void writeImageHeaderBox() throws IOException {
        this.fi.writeInt(22);
        this.fi.writeInt(1768449138);
        this.fi.writeInt(this.height);
        this.fi.writeInt(this.width);
        this.fi.writeShort(this.nc);
        if (this.bpcVaries) {
            this.fi.writeByte(255);
        } else {
            this.fi.writeByte(this.bpc[0] - 1);
        }
        this.fi.writeByte(7);
        this.fi.writeByte(1);
        this.fi.writeByte(0);
    }

    public void writeContiguousCodeStreamBox(byte[] cs) throws IOException {
        this.fi.writeInt(this.clength + 8);
        this.fi.writeInt(1785737827);
        for (int i = 0; i < this.clength; ++i) {
            this.fi.writeByte(cs[i]);
        }
    }
}

