/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.Misc;

public class CompareNetcdf2 {
    private Formatter f;
    private boolean showCompare = false;
    private boolean showEach = false;
    private boolean compareData = false;
    private static final double TOL = 1.0E-5;
    private static final float TOLF = 1.0E-5f;

    public static boolean compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f) {
        return CompareNetcdf2.compareFiles(org, copy, f, false, false, false);
    }

    public static boolean compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f, boolean _compareData, boolean _showCompare, boolean _showEach) {
        CompareNetcdf2 tc = new CompareNetcdf2(f, _showCompare, _showEach, _compareData);
        return tc.compare(org, copy);
    }

    public static boolean compareLists(List org, List copy, Formatter f) {
        boolean ok1 = CompareNetcdf2.checkContains("first", org, copy, f);
        boolean ok2 = CompareNetcdf2.checkContains("second", copy, org, f);
        return ok1 && ok2;
    }

    private static boolean checkContains(String what, List container, List wantList, Formatter f) {
        boolean ok = true;
        for (Object want1 : wantList) {
            int index2 = container.indexOf(want1);
            if (index2 >= 0) continue;
            f.format("  ** %s missing in %s %n", want1, what);
            ok = false;
        }
        return ok;
    }

    public CompareNetcdf2() {
        this(new Formatter(System.out));
    }

    public CompareNetcdf2(Formatter f) {
        this(f, false, false, false);
    }

    public CompareNetcdf2(Formatter f, boolean showCompare, boolean showEach, boolean compareData) {
        this.f = f;
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy) {
        return this.compare(org, copy, this.showCompare, this.showEach, this.compareData);
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, boolean showCompare, boolean showEach, boolean compareData) {
        return this.compare(org, copy, null, showCompare, showEach, compareData);
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, ObjFilter filter, boolean showCompare, boolean showEach, boolean compareData) {
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
        this.f.format(" First file = %s%n", org.getLocation());
        this.f.format(" Second file= %s%n", copy.getLocation());
        long start = System.currentTimeMillis();
        boolean ok = this.compareGroups(org.getRootGroup(), copy.getRootGroup(), filter);
        this.f.format(" Files are the same = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        this.f.format(" Time to compare = %d msecs%n", took);
        if (org instanceof NetcdfDataset && copy instanceof NetcdfDataset) {
            NetcdfDataset orgds = (NetcdfDataset)org;
            NetcdfDataset copyds = (NetcdfDataset)copy;
            ArrayList matches = new ArrayList();
            ok &= this.checkAll("Dataset CS:", orgds.getCoordinateSystems(), copyds.getCoordinateSystems(), matches);
            for (int i = 0; i < matches.size(); i += 2) {
                CoordinateSystem orgCs = (CoordinateSystem)matches.get(i);
                CoordinateSystem copyCs = (CoordinateSystem)matches.get(i + 1);
                ok &= this.compareCoordinateSystem(orgCs, copyCs, filter);
            }
        }
        return ok;
    }

    public boolean compareVariables(NetcdfFile org, NetcdfFile copy) {
        Variable copyVar;
        this.f.format("Original = %s%n", org.getLocation());
        this.f.format("CompareTo= %s%n", copy.getLocation());
        boolean ok = true;
        for (Variable orgV : org.getVariables()) {
            copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" MISSING '%s' in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, null, this.compareData, true);
        }
        this.f.format("%n", new Object[0]);
        for (Variable orgV : copy.getVariables()) {
            copyVar = org.findVariable(orgV.getShortName());
            if (copyVar != null) continue;
            this.f.format(" MISSING '%s' in 1st file%n", orgV.getFullName());
            ok = false;
        }
        return ok;
    }

    private boolean compareGroups(Group org, Group copy, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("compare Group %s to %s %n", org.getShortName(), copy.getShortName());
        }
        boolean ok = true;
        if (!org.getShortName().equals(copy.getShortName())) {
            this.f.format(" ** names are different %s != %s %n", org.getShortName(), copy.getShortName());
            ok = false;
        }
        ok &= this.checkDimensions(org.getDimensions(), copy.getDimensions());
        ok &= this.checkDimensions(copy.getDimensions(), org.getDimensions());
        ok &= this.checkAttributes(null, org.getAttributes(), copy.getAttributes(), filter);
        ok &= this.checkEnums(org, copy);
        for (Variable orgV : org.getVariables()) {
            Variable copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" ** cant find variable %s in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, filter, this.compareData, true);
        }
        for (Variable copyV : copy.getVariables()) {
            Variable orgV = org.findVariable(copyV.getShortName());
            if (orgV != null) continue;
            this.f.format(" ** cant find variable %s in 1st file%n", copyV.getFullName());
            ok = false;
        }
        ArrayList groups = new ArrayList();
        String name = org.isRoot() ? "root" : org.getFullName();
        ok &= this.checkAll(name, org.getGroups(), copy.getGroups(), groups);
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group ncmlGroup = (Group)groups.get(i + 1);
            ok &= this.compareGroups(orgGroup, ncmlGroup, filter);
        }
        return ok;
    }

    public boolean compareVariable(Variable org, Variable copy) {
        return this.compareVariables(org, copy, null, this.compareData, true);
    }

    private boolean compareVariables(Variable org, Variable copy, ObjFilter filter, boolean compareData, boolean justOne) {
        int i;
        boolean ok = true;
        if (this.showCompare) {
            this.f.format("compare Variable %s to %s %n", org.getFullName(), copy.getFullName());
        }
        if (!org.getFullName().equals(copy.getFullName())) {
            this.f.format(" ** names are different %s != %s %n", org.getFullName(), copy.getFullName());
            ok = false;
        }
        if (filter != null && filter.varDataTypeCheckOk(org) && org.getDataType() != copy.getDataType()) {
            this.f.format(" ** %s dataTypes are different %s != %s %n", new Object[]{org.getFullName(), org.getDataType(), copy.getDataType()});
            ok = false;
        }
        if (org.isUnsigned() != copy.isUnsigned()) {
            this.f.format(" %s isUnsigned differs %s != %s%n", org.getFullName(), org.isUnsigned(), copy.isUnsigned());
            ok = false;
        }
        ok &= this.checkDimensions(org.getDimensions(), copy.getDimensions());
        ok &= this.checkDimensions(copy.getDimensions(), org.getDimensions());
        ok &= this.checkAttributes(org, org.getAttributes(), copy.getAttributes(), filter);
        if (compareData) {
            try {
                this.compareVariableData(org, copy, this.showCompare, justOne);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter(5000);
                e.printStackTrace(new PrintWriter(sw));
                this.f.format("%s", sw.toString());
            }
        }
        if (org instanceof Structure) {
            if (!(copy instanceof Structure)) {
                this.f.format("  ** %s not Structure%n", org);
                ok = false;
            } else {
                Structure orgS = (Structure)org;
                Structure ncmlS = (Structure)copy;
                ArrayList vars = new ArrayList();
                ok &= this.checkAll("struct " + orgS.getNameAndDimensions(), orgS.getVariables(), ncmlS.getVariables(), vars);
                for (i = 0; i < vars.size(); i += 2) {
                    Variable orgV = (Variable)vars.get(i);
                    Variable ncmlV = (Variable)vars.get(i + 1);
                    ok &= this.compareVariables(orgV, ncmlV, filter, false, true);
                }
            }
        }
        if (org instanceof VariableEnhanced && copy instanceof VariableEnhanced) {
            VariableEnhanced orgds = (VariableEnhanced)((Object)org);
            VariableEnhanced copyds = (VariableEnhanced)((Object)copy);
            ArrayList matches = new ArrayList();
            ok &= this.checkAll(orgds.getFullName(), orgds.getCoordinateSystems(), copyds.getCoordinateSystems(), matches);
            for (i = 0; i < matches.size(); i += 2) {
                CoordinateSystem orgCs = (CoordinateSystem)matches.get(i);
                CoordinateSystem copyCs = (CoordinateSystem)matches.get(i + 1);
                ok &= this.compareCoordinateSystem(orgCs, copyCs, filter);
            }
        }
        return ok;
    }

    private boolean compareCoordinateSystem(CoordinateSystem cs1, CoordinateSystem cs2, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("compare CoordinateSystem '%s' to '%s' %n", cs1.getName(), cs2.getName());
        }
        ArrayList matchAxes = new ArrayList();
        boolean ok = this.checkAll(cs1.getName(), cs1.getCoordinateAxes(), cs2.getCoordinateAxes(), matchAxes);
        for (int i = 0; i < matchAxes.size(); i += 2) {
            CoordinateAxis orgCs = (CoordinateAxis)matchAxes.get(i);
            CoordinateAxis copyCs = (CoordinateAxis)matchAxes.get(i + 1);
            ok &= this.compareCoordinateAxis(orgCs, copyCs, filter);
        }
        ArrayList matchTransforms = new ArrayList();
        return ok &= this.checkAll(cs1.getName(), cs1.getCoordinateTransforms(), cs2.getCoordinateTransforms(), matchTransforms);
    }

    private boolean compareCoordinateAxis(CoordinateAxis a1, CoordinateAxis a2, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("  compare CoordinateAxis '%s' to '%s' %n", a1.getShortName(), a2.getShortName());
        }
        this.compareVariable(a1, a2);
        return true;
    }

    private boolean checkAttributes(Variable v, List<Attribute> list1, List<Attribute> list2, ObjFilter filter) {
        boolean ok = true;
        String name = v == null ? "global" : "variable " + v.getFullName();
        for (Attribute att1 : list1) {
            if (filter != null && !filter.attCheckOk(v, att1)) continue;
            ok &= this.checkEach(name, att1, "file1", list1, "file2", list2, null);
        }
        for (Attribute att2 : list2) {
            if (filter != null && !filter.attCheckOk(v, att2)) continue;
            ok &= this.checkEach(name, att2, "file2", list2, "file1", list1, null);
        }
        return ok;
    }

    private boolean checkDimensions(List<Dimension> list1, List<Dimension> list2) {
        boolean ok = true;
        for (Dimension d1 : list1) {
            if (!d1.isShared()) continue;
            boolean hasit = list2.contains(d1);
            if (!hasit) {
                this.f.format("  ** Missing dim %s not in file2 %n", d1);
            }
            ok &= hasit;
        }
        return ok;
    }

    private boolean checkEnums(Group org, Group copy) {
        boolean ok = true;
        for (EnumTypedef enum1 : org.getEnumTypedefs()) {
            EnumTypedef enum2;
            if (this.showCompare) {
                this.f.format("compare Enum %s%n", enum1.getShortName());
            }
            if ((enum2 = copy.findEnumeration(enum1.getShortName())) == null) {
                this.f.format("  ** Enum %s not in file2 %n", enum1.getShortName());
                ok = false;
                continue;
            }
            if (enum1.equals(enum2)) continue;
            this.f.format("  ** Enum %s not equal%n  %s%n  %s%n", enum1.getShortName(), enum1, enum2);
            ok = false;
        }
        for (EnumTypedef enum2 : copy.getEnumTypedefs()) {
            EnumTypedef enum1 = org.findEnumeration(enum2.getShortName());
            if (enum1 != null) continue;
            this.f.format("  ** Enum %s not in file1 %n", enum2.getShortName());
            ok = false;
        }
        return ok;
    }

    private boolean checkAll(String what, List list1, List list2, List result) {
        boolean ok = true;
        for (Object aList1 : list1) {
            ok &= this.checkEach(what, aList1, "file1", list1, "file2", list2, result);
        }
        for (Object aList2 : list2) {
            ok &= this.checkEach(what, aList2, "file2", list2, "file1", list1, result);
        }
        return ok;
    }

    private boolean checkEach(String what, Object want1, String name1, List list1, String name2, List list2, List result) {
        boolean ok = true;
        try {
            int index2 = list2.indexOf(want1);
            if (index2 < 0) {
                this.f.format("  ** %s: %s 0x%x (%s) not in %s %n", what, want1, want1.hashCode(), name1, name2);
                ok = false;
            } else {
                Object want2 = list2.get(index2);
                int index1 = list1.indexOf(want2);
                if (index1 < 0) {
                    this.f.format("  ** %s: %s 0x%x (%s) not in %s %n", what, want2, want2.hashCode(), name2, name1);
                    ok = false;
                } else {
                    Object want = list1.get(index1);
                    if (!want.equals(want1)) {
                        this.f.format("  ** %s: %s 0x%x (%s) not equal to %s 0x%x (%s) %n", what, want1, want1.hashCode(), name1, want2, want2.hashCode(), name2);
                        ok = false;
                    } else {
                        if (this.showEach) {
                            this.f.format("  OK <%s> equals <%s>%n", want1, want2);
                        }
                        if (result != null) {
                            result.add(want1);
                            result.add(want2);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.f.format(" *** Throwable= %s %n", t.getMessage());
        }
        return ok;
    }

    private void compareVariableData(Variable var1, Variable var2, boolean showCompare, boolean justOne) throws IOException {
        Array data1 = var1.read();
        Array data2 = var2.read();
        if (showCompare) {
            this.f.format(" compareArrays %s unlimited=%s size=%d%n", var1.getNameAndDimensions(), var1.isUnlimited(), data1.getSize());
        }
        this.compareData(var1.getFullName(), data1, data2, justOne);
        if (showCompare) {
            this.f.format("   ok%n", new Object[0]);
        }
    }

    public boolean compareData(String name, Array data1, double[] data2) {
        Array data2a = Array.factory(DataType.DOUBLE, new int[]{data2.length}, (Object)data2);
        return this.compareData(name, data1, data2a, 1.0E-5, false, false);
    }

    public boolean compareData(String name, double[] data1, double[] data2) {
        Array data1a = Array.factory(DataType.DOUBLE, new int[]{data1.length}, (Object)data1);
        Array data2a = Array.factory(DataType.DOUBLE, new int[]{data2.length}, (Object)data2);
        return this.compareData(name, data1a, data2a, 1.0E-5, false, false);
    }

    public boolean compareData(String name, Array data1, Array data2, boolean justOne) {
        return this.compareData(name, data1, data2, 1.0E-5, justOne, true);
    }

    public boolean compareData(String name, Array data1, Array data2) {
        return this.compareData(name, data1, data2, 1.0E-5, false, true);
    }

    private boolean compareData(String name, Array data1, Array data2, double tol, boolean justOne, boolean testTypes) {
        boolean ok;
        block9: {
            IndexIterator iter2;
            IndexIterator iter1;
            DataType dt;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                ok = true;
                                if (data1.getSize() != data2.getSize()) {
                                    this.f.format(" DIFF %s: size %d !== %d%n", name, data1.getSize(), data2.getSize());
                                    ok = false;
                                }
                                if (testTypes && data1.getElementType() != data2.getElementType()) {
                                    this.f.format(" DIFF %s: element type %s !== %s%n", name, data1.getElementType(), data2.getElementType());
                                    ok = false;
                                }
                                if (!ok) {
                                    return false;
                                }
                                dt = DataType.getType(data1.getElementType());
                                iter1 = data1.getIndexIterator();
                                iter2 = data2.getIndexIterator();
                                if (dt != DataType.DOUBLE) break block10;
                                while (iter1.hasNext() && iter2.hasNext()) {
                                    double v1 = iter1.getDoubleNext();
                                    double v2 = iter2.getDoubleNext();
                                    if (Double.isNaN(v1) && Double.isNaN(v2) || Misc.closeEnough(v1, v2, tol)) continue;
                                    this.f.format(" DIFF %s: %f != %f count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                                    ok = false;
                                    if (!justOne) continue;
                                    break block9;
                                }
                                break block9;
                            }
                            if (dt != DataType.FLOAT) break block11;
                            while (iter1.hasNext() && iter2.hasNext()) {
                                float v1 = iter1.getFloatNext();
                                float v2 = iter2.getFloatNext();
                                if (Float.isNaN(v1) && Float.isNaN(v2) || Misc.closeEnough(v1, v2, (float)tol)) continue;
                                this.f.format(" DIFF %s: %f != %f count=%s diff = %f pdiff = %f %n", name, Float.valueOf(v1), Float.valueOf(v2), iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                                ok = false;
                                if (!justOne) continue;
                                break block9;
                            }
                            break block9;
                        }
                        if (dt != DataType.INT) break block12;
                        while (iter1.hasNext() && iter2.hasNext()) {
                            int v2;
                            int v1 = iter1.getIntNext();
                            if (v1 == (v2 = iter2.getIntNext())) continue;
                            this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                            ok = false;
                            if (!justOne) continue;
                            break block9;
                        }
                        break block9;
                    }
                    if (dt != DataType.SHORT) break block13;
                    while (iter1.hasNext() && iter2.hasNext()) {
                        short v2;
                        short v1 = iter1.getShortNext();
                        if (v1 == (v2 = iter2.getShortNext())) continue;
                        this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                        ok = false;
                        if (!justOne) continue;
                        break block9;
                    }
                    break block9;
                }
                if (dt != DataType.BYTE) break block14;
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v2;
                    byte v1 = iter1.getByteNext();
                    if (v1 == (v2 = iter2.getByteNext())) continue;
                    this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                    ok = false;
                    if (!justOne) continue;
                    break block9;
                }
                break block9;
            }
            if (dt != DataType.STRUCTURE) break block9;
            while (iter1.hasNext() && iter2.hasNext()) {
                this.compareStructureData((StructureData)iter1.next(), (StructureData)iter2.next(), tol, justOne);
            }
        }
        return ok;
    }

    public boolean compareStructureData(StructureData sdata1, StructureData sdata2, double tol, boolean justOne) {
        boolean ok = true;
        StructureMembers sm1 = sdata1.getStructureMembers();
        StructureMembers sm2 = sdata2.getStructureMembers();
        if (sm1.getMembers().size() != sm2.getMembers().size()) {
            this.f.format(" size %d !== %d%n", sm1.getMembers().size(), sm2.getMembers().size());
            ok = false;
        }
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            if (m1.getName().equals("time")) continue;
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            Array data1 = sdata1.getArray(m1);
            Array data2 = sdata2.getArray(m2);
            ok &= this.compareData(m1.getName(), data1, data2, tol, justOne, true);
        }
        return ok;
    }

    public static double diff(double d1, double d2) {
        return Math.abs(d1 - d2);
    }

    public static double pdiff(double d1, double d2) {
        return Math.abs((d1 - d2) / d1);
    }

    public static void main(String[] arg) throws IOException {
        String usage = "usage: ucar.nc2.util.CompareNetcdf2 file1 file2 [-showEach] [-compareData]";
        if (arg.length < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean showEach = false;
        boolean compareData = false;
        String file1 = arg[0];
        String file2 = arg[1];
        for (int i = 2; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-showEach")) {
                showEach = true;
            }
            if (!s.equalsIgnoreCase("-compareData")) continue;
            compareData = true;
        }
        NetcdfFile ncfile1 = NetcdfDataset.open(file1);
        NetcdfFile ncfile2 = NetcdfDataset.open(file2);
        CompareNetcdf2.compareFiles(ncfile1, ncfile2, new Formatter(System.out), true, compareData, showEach);
        ncfile1.close();
        ncfile2.close();
    }

    public static class Netcdf4ObjectFilter
    implements ObjFilter {
        @Override
        public boolean attCheckOk(Variable v, Attribute att) {
            String name = att.getShortName();
            if (name.equals("_ChunkSizes")) {
                return false;
            }
            if (name.equals("_FillValue")) {
                return false;
            }
            if (name.equals("_lastModified")) {
                return false;
            }
            if (name.equals("_Netcdf4Dimid")) {
                return false;
            }
            if (name.equals("_Netcdf4Coordinates")) {
                return false;
            }
            return !name.equals("_nc3_strict");
        }

        @Override
        public boolean varDataTypeCheckOk(Variable v) {
            if (v.getDataType() == DataType.CHAR) {
                return false;
            }
            return v.getDataType() != DataType.STRING;
        }
    }

    public static interface ObjFilter {
        public boolean attCheckOk(Variable var1, Attribute var2);

        public boolean varDataTypeCheckOk(Variable var1);
    }
}

