/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib1RecordScanner {
    private static Logger log = LoggerFactory.getLogger(Grib1RecordScanner.class);
    private static final KMPMatch matcher = new KMPMatch(new byte[]{71, 82, 73, 66});
    private static final boolean debug = false;
    private static final boolean debugGds = false;
    private static final int maxScan = 16000;
    private Map<Long, Grib1SectionGridDefinition> gdsMap = new HashMap<Long, Grib1SectionGridDefinition>();
    private RandomAccessFile raf = null;
    private byte[] header;
    private long lastPos = 0L;

    public static boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            boolean found = raf.searchForward(matcher, 16000);
            if (!found) {
                return false;
            }
            raf.skipBytes(4);
            int len = GribNumbers.uint3(raf);
            int edition = raf.read();
            if (edition != 1) {
                return false;
            }
            if ((long)len > raf.length()) {
                return false;
            }
            raf.skipBytes(len - 12);
            for (int i = 0; i < 4; ++i) {
                if (raf.read() == 55) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Grib1RecordScanner(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        raf.order(0);
        this.lastPos = 0L;
    }

    public boolean hasNext() throws IOException {
        boolean more;
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        long foundAt = 0L;
        while (true) {
            this.raf.seek(this.lastPos);
            more = this.raf.searchForward(matcher, -1);
            if (!more) break;
            foundAt = this.raf.getFilePointer();
            this.raf.skipBytes(7);
            int edition = this.raf.read();
            if (edition == 1) break;
            this.lastPos = this.raf.getFilePointer();
        }
        if (more) {
            int sizeHeader = (int)(foundAt - this.lastPos);
            if (sizeHeader > 100) {
                sizeHeader = 100;
            }
            long startPos = foundAt - (long)sizeHeader;
            this.header = new byte[sizeHeader];
            this.raf.seek(startPos);
            this.raf.readFully(this.header);
            this.raf.seek(foundAt);
        }
        return more;
    }

    public Grib1Record next() throws IOException {
        block10: {
            Grib1SectionIndicator is = null;
            try {
                Grib1SectionGridDefinition gds;
                is = new Grib1SectionIndicator(this.raf);
                Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(this.raf);
                Grib1SectionGridDefinition grib1SectionGridDefinition = gds = pds.gdsExists() ? new Grib1SectionGridDefinition(this.raf) : new Grib1SectionGridDefinition(pds);
                if (!pds.gdsExists()) {
                    // empty if block
                }
                Grib1SectionBitMap bitmap = pds.bmsExists() ? new Grib1SectionBitMap(this.raf) : null;
                Grib1SectionBinaryData dataSection = new Grib1SectionBinaryData(this.raf);
                if (dataSection.getStartingPosition() + (long)dataSection.getLength() > is.getEndPos()) {
                    log.warn("BAD GRIB-1 data message at " + dataSection.getStartingPosition() + " header= " + StringUtil2.cleanup(this.header) + " for=" + this.raf.getLocation());
                    throw new IllegalStateException("Illegal Grib1SectionBinaryData Message Length");
                }
                long crc = gds.calcCRC();
                Grib1SectionGridDefinition gdsCached = this.gdsMap.get(crc);
                if (gdsCached != null) {
                    gds = gdsCached;
                } else {
                    this.gdsMap.put(crc, gds);
                }
                long ending = is.getEndPos();
                boolean foundEnding = true;
                this.raf.seek(ending - 4L);
                for (int i = 0; i < 4; ++i) {
                    if (this.raf.read() == 55) continue;
                    foundEnding = false;
                    String clean = StringUtil2.cleanup(this.header);
                    if (clean.length() > 40) {
                        clean = clean.substring(0, 40) + "...";
                    }
                    log.debug("Missing End of GRIB message at pos=" + ending + " header= " + clean + " for=" + this.raf.getLocation());
                    break;
                }
                if (foundEnding) {
                    this.lastPos = this.raf.getFilePointer();
                    return new Grib1Record(this.header, is, gds, pds, bitmap, dataSection);
                }
                this.lastPos += 20L;
                if (this.hasNext()) {
                    return this.next();
                }
            }
            catch (Throwable t) {
                long pos = is == null ? -1L : is.getStartPos();
                log.warn("Bad Grib1 record in file {}, skipping pos={}", (Object)this.raf.getLocation(), (Object)pos);
                this.lastPos += 20L;
                if (!this.hasNext()) break block10;
                return this.next();
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        int count = 0;
        RandomAccessFile raf = new RandomAccessFile("Q:/cdmUnitTest/formats/grib1/ECMWF.hybrid.grib1", "r");
        Grib1RecordScanner scan = new Grib1RecordScanner(raf);
        while (scan.hasNext()) {
            scan.next();
            ++count;
        }
        raf.close();
        System.out.printf("count=%d%n", count);
    }
}

