/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import ucar.ma2.DataType;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib1.Grib1DataReader;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Record {
    private final Grib1SectionIndicator is;
    private final Grib1SectionGridDefinition gdss;
    private final Grib1SectionProductDefinition pdss;
    private final Grib1SectionBitMap bitmap;
    private final Grib1SectionBinaryData dataSection;
    private final byte[] header;
    private int file;
    private Grib1Gds gds = null;
    private Grib1ParamTime ptime;
    public static Grib1Record lastRecordRead;

    public Grib1Record(byte[] header, Grib1SectionIndicator is, Grib1SectionGridDefinition gdss, Grib1SectionProductDefinition pdss, Grib1SectionBitMap bitmap, Grib1SectionBinaryData dataSection) {
        this.header = header;
        this.is = is;
        this.gdss = gdss;
        this.pdss = pdss;
        this.bitmap = bitmap;
        this.dataSection = dataSection;
    }

    public Grib1Record(RandomAccessFile raf) throws IOException {
        this.header = null;
        this.is = new Grib1SectionIndicator(raf);
        this.pdss = new Grib1SectionProductDefinition(raf);
        this.gdss = this.pdss.gdsExists() ? new Grib1SectionGridDefinition(raf) : new Grib1SectionGridDefinition(this.pdss);
        this.bitmap = this.pdss.bmsExists() ? new Grib1SectionBitMap(raf) : null;
        this.dataSection = new Grib1SectionBinaryData(raf);
    }

    Grib1Record(Grib1Record from) {
        this.header = from.header;
        this.is = from.is;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.bitmap = from.bitmap;
        this.dataSection = from.dataSection;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib1SectionIndicator getIs() {
        return this.is;
    }

    public Grib1SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib1Gds getGDS() {
        if (this.gds == null) {
            this.gds = this.gdss.getGDS();
        }
        return this.gds;
    }

    public Grib1SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib1SectionBitMap getBitMapSection() {
        return this.bitmap;
    }

    public Grib1SectionBinaryData getDataSection() {
        return this.dataSection;
    }

    public CalendarDate getReferenceDate() {
        return this.pdss.getReferenceDate();
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public Grib1ParamTime getParamTime(Grib1Customizer cust) {
        if (this.ptime == null) {
            this.ptime = cust.getParamTime(this.pdss);
        }
        return this.ptime;
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        return this.readData(raf, GribData.getInterpolationMethod());
    }

    public float[] readDataRaw(RandomAccessFile raf, GribData.InterpolationMethod method) throws IOException {
        return this.readData(raf, method);
    }

    private float[] readData(RandomAccessFile raf, GribData.InterpolationMethod method) throws IOException {
        Grib1Gds gds = this.getGDS();
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNx(), gds.getNy(), gds.getNpts(), this.dataSection.getStartingPosition());
        byte[] bm = this.bitmap == null ? null : this.bitmap.getBitmap(raf);
        float[] data = reader.getData(raf, bm);
        if (this.gdss.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw(), method);
        }
        lastRecordRead = this;
        return data;
    }

    public void showDataInfo(RandomAccessFile raf, Formatter f) throws IOException {
        Grib1Gds gds = this.getGDS();
        f.format(" decimal scale = %d%n", this.pdss.getDecimalScale());
        f.format("     scan mode = %d%n", gds.getScanMode());
        f.format("            nx = %d%n", gds.getNx());
        f.format("            ny = %d%n", gds.getNy());
        f.format("          Npts = %d%n", gds.getNpts());
        f.format("        isThin = %s%n", this.gdss.isThin());
        GribData.Info info = this.getBinaryDataInfo(raf);
        f.format("   dataLength = %d%n", info.dataLength);
        f.format("    ----flag = %s%n", Long.toHexString(info.flag));
        f.format("        data = %s%n", info.getGridPointS());
        f.format("     packing = %s%n", info.getPackingS());
        f.format("        type = %s%n", info.getDataTypeS());
        f.format("        more = %s%n", info.hasMore());
        f.format("    binscale = %d%n", info.binaryScaleFactor);
        f.format("    decscale = %d%n", info.decimalScaleFactor);
        f.format("reference value = %f%n", Float.valueOf(info.referenceValue));
        f.format("      nbits = %d%n", info.numberOfBits);
    }

    public static float[] readData(RandomAccessFile raf, long startPos) throws IOException {
        raf.seek(startPos);
        Grib1Record gr = new Grib1Record(raf);
        return gr.readData(raf);
    }

    public GribData.Info getBinaryDataInfo(RandomAccessFile raf) throws IOException {
        GribData.Info info = this.dataSection.getBinaryDataInfo(raf);
        info.decimalScaleFactor = this.pdss.getDecimalScale();
        info.bitmapLength = this.bitmap == null ? 0 : this.bitmap.getLength(raf);
        info.nPoints = this.getGDS().getNpts();
        info.msgLength = this.is.getMessageLength();
        if (this.bitmap == null) {
            info.ndataPoints = info.nPoints;
        } else {
            int bits = 0;
            byte[] bm = this.bitmap.getBitmap(raf);
            if (bm == null) {
                info.ndataPoints = info.nPoints;
            } else {
                for (byte b : bm) {
                    short s = DataType.unsignedByteToShort(b);
                    bits += Long.bitCount(s);
                }
                info.ndataPoints = bits;
            }
        }
        return info;
    }

    public int[] readRawData(RandomAccessFile raf) throws IOException {
        Grib1Gds gds = this.getGDS();
        Grib1DataReader reader = new Grib1DataReader(this.pdss.getDecimalScale(), gds.getScanMode(), gds.getNx(), gds.getNy(), gds.getNpts(), this.dataSection.getStartingPosition());
        byte[] bm = this.bitmap == null ? null : this.bitmap.getBitmap(raf);
        return reader.getDataRaw(raf, bm);
    }
}

