/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;

class GribCollectionWriter {
    public static final int currentVersion = 1;

    GribCollectionWriter() {
    }

    protected GribCollectionProto.Gds writeGdsProto(GribHorizCoordSystem hcs) throws IOException {
        return this.writeGdsProto(hcs.getRawGds(), hcs.getPredefinedGridDefinition());
    }

    protected GribCollectionProto.Gds writeGdsProto(byte[] rawGds, int predefinedGridDefinition) throws IOException {
        GribCollectionProto.Gds.Builder b = GribCollectionProto.Gds.newBuilder();
        if (predefinedGridDefinition >= 0) {
            b.setPredefinedGridDefinition(predefinedGridDefinition);
        } else {
            b.setGds(ByteString.copyFrom(rawGds));
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateRuntime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (int idx = 0; idx < coord.getSize(); ++idx) {
            long runtime = coord.getRuntime(idx);
            b.addMsecs(runtime);
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (Integer offset : coord.getOffsetSorted()) {
            b.addValues(offset.intValue());
        }
        int[] time2runtime = coord.getTime2runtime();
        if (time2runtime != null) {
            for (int val : time2runtime) {
                b.addTime2Runtime(val);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTimeIntv coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (TimeCoord.Tinv tinv : coord.getTimeIntervals()) {
            b.addValues(tinv.getBounds1());
            b.addBound(tinv.getBounds2());
        }
        int[] time2runtime = coord.getTime2runtime();
        if (time2runtime != null) {
            for (int val : time2runtime) {
                b.addTime2Runtime(val);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateVert coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (VertCoord.Level level : coord.getLevelSorted()) {
            if (coord.isLayer()) {
                b.addValues((float)level.getValue1());
                b.addBound((float)level.getValue2());
                continue;
            }
            b.addValues((float)level.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateEns coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (EnsCoord.Coord level : coord.getEnsSorted()) {
            b.addValues(level.getCode());
            b.addBound(level.getEnsMember());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime2D coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setType(coord.getType().ordinal());
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        CoordinateRuntime runtimeCoord = coord.getRuntimeCoordinate();
        for (int idx = 0; idx < runtimeCoord.getSize(); ++idx) {
            long l = runtimeCoord.getRuntime(idx);
            b.addMsecs(l);
        }
        b.setIsOrthogonal(coord.isOrthogonal());
        b.setIsRegular(coord.isRegular());
        for (Coordinate coordinate : coord.getTimesForSerialization()) {
            if (coordinate.getType() == Coordinate.Type.time) {
                b.addTimes(this.writeCoordProto((CoordinateTime)coordinate));
                continue;
            }
            b.addTimes(this.writeCoordProto((CoordinateTimeIntv)coordinate));
        }
        return b.build();
    }

    protected GribCollectionProto.FcConfig writeConfig(FeatureCollectionConfig config) throws IOException {
        GribCollectionProto.IntMap.Builder bIntMap;
        GribCollectionProto.FcConfig.Builder b = GribCollectionProto.FcConfig.newBuilder();
        b.setName(config.collectionName);
        b.setCollectionSpec(config.spec);
        b.setPartitionType(config.ptype.toString());
        if (config.dateFormatMark != null) {
            b.setDateFormatMark(config.dateFormatMark);
        }
        FeatureCollectionConfig.GribConfig gribConfig = config.gribConfig;
        if (gribConfig.gdsHash != null) {
            for (Map.Entry<Integer, Integer> entry : gribConfig.gdsHash.entrySet()) {
                bIntMap = GribCollectionProto.IntMap.newBuilder();
                bIntMap.setFrom(entry.getKey());
                bIntMap.setTo(entry.getValue());
                b.addGdsConvert(bIntMap);
            }
        }
        b.setPdsUseGenType(gribConfig.useGenType);
        b.setPdsUseTableVersion(gribConfig.useTableVersion);
        b.setPdsIntvMerge(gribConfig.intvMerge);
        b.setPdsUseCenter(gribConfig.useCenter);
        if (gribConfig.intvFilter != null) {
            b.setIntvExcludeZero(gribConfig.intvFilter.isZeroExcluded());
            for (FeatureCollectionConfig.GribIntvFilterParam gribIntvFilterParam : gribConfig.intvFilter.filter) {
                GribCollectionProto.IntvFilter.Builder bIntv = GribCollectionProto.IntvFilter.newBuilder();
                bIntv.setVariableId(gribIntvFilterParam.id);
                bIntv.setIntvLength(gribIntvFilterParam.intvLength);
                if (gribIntvFilterParam.prob != Integer.MIN_VALUE) {
                    bIntv.setIntvProb(gribIntvFilterParam.prob);
                }
                b.addIntvFilter(bIntv);
            }
        }
        if (gribConfig.tuc != null) {
            for (Map.Entry entry : gribConfig.tuc.map.entrySet()) {
                bIntMap = GribCollectionProto.IntMap.newBuilder();
                bIntMap.setFrom((Integer)entry.getKey());
                bIntMap.setTo((Integer)entry.getValue());
                b.addTimeUnitConvert(bIntMap);
            }
        }
        if (gribConfig.userTimeUnit != null) {
            b.setUserTimeUnit(gribConfig.userTimeUnit.toString());
        }
        return b.build();
    }

    protected FeatureCollectionConfig readConfig(boolean isGrib1, GribCollectionProto.FcConfig pconfig) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        config.name = pconfig.getName();
        config.collectionName = pconfig.getName();
        config.type = isGrib1 ? FeatureCollectionType.GRIB1 : FeatureCollectionType.GRIB2;
        config.spec = pconfig.getCollectionSpec();
        config.ptype = FeatureCollectionConfig.PartitionType.valueOf(pconfig.getPartitionType());
        if (pconfig.hasDateFormatMark()) {
            config.dateFormatMark = pconfig.getDateFormatMark();
        }
        if (pconfig.getGdsConvertCount() > 0) {
            config.gribConfig.gdsHash = new HashMap<Integer, Integer>();
            for (GribCollectionProto.IntMap pIntMap : pconfig.getGdsConvertList()) {
                config.gribConfig.gdsHash.put(pIntMap.getFrom(), pIntMap.getTo());
            }
        }
        config.gribConfig.useGenType = pconfig.getPdsUseGenType();
        config.gribConfig.useTableVersion = pconfig.getPdsUseTableVersion();
        config.gribConfig.intvMerge = pconfig.getPdsIntvMerge();
        config.gribConfig.useCenter = pconfig.getPdsUseCenter();
        boolean isZeroExcluded = pconfig.getIntvExcludeZero();
        if (isZeroExcluded || pconfig.getIntvFilterCount() > 0) {
            config.gribConfig.intvFilter = new FeatureCollectionConfig.GribIntvFilter();
            config.gribConfig.intvFilter.isZeroExcluded = isZeroExcluded;
            config.gribConfig.intvFilter.filter = new ArrayList<FeatureCollectionConfig.GribIntvFilterParam>();
            for (GribCollectionProto.IntvFilter pi : pconfig.getIntvFilterList()) {
                int prob = pi.hasIntvProb() ? pi.getIntvProb() : Integer.MIN_VALUE;
                config.gribConfig.intvFilter.filter.add(new FeatureCollectionConfig.GribIntvFilterParam(pi.getVariableId(), pi.getIntvLength(), prob));
            }
        }
        if (pconfig.getTimeUnitConvertCount() > 0) {
            config.gribConfig.tuc = new FeatureCollectionConfig.TimeUnitConverterHash();
            for (GribCollectionProto.IntMap pIntMap : pconfig.getTimeUnitConvertList()) {
                config.gribConfig.tuc.map.put(pIntMap.getFrom(), pIntMap.getTo());
            }
        }
        if (pconfig.hasUserTimeUnit()) {
            config.gribConfig.setUserTimeUnit(pconfig.getUserTimeUnit());
        }
        return config;
    }
}

