/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.client.CredentialsProvider;
import ucar.httpservices.HTTPAuthStore;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPSession;

public class HTTPCachingProvider
implements CredentialsProvider {
    static final int MAX_RETRIES = 3;
    static final String PRINCIPAL = "ucar.nc2.principal";
    static final String URI = "ucar.nc2.url";
    static final String CREDENTIALSPROVIDER = "ucar.nc2.credentialsprovider";
    static final String KEYSTOREPATH = "ucar.nc2.keystore";
    static final String KEYSTOREPASSWORD = "ucar.nc2.keystorepassword";
    static final String TRUSTSTOREPATH = "ucar.nc2.truststore";
    static final String TRUSTSTOREPASSWORD = "ucar.nc2.truststorepassword";
    static final String CREDENTIALS = "ucar.nc2.credentials";
    static final String AUTHSTRING = "ucar.nc2.authstring";
    static String SCHEME = "ucar.nc2.scheme";
    static String PASSWORD = "ucar.nc2.password";
    static String USER = "ucar.nc2.user";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    public static boolean TESTING = false;
    protected HTTPAuthStore store = null;
    protected static List<Auth> cache = new ArrayList<Auth>();
    protected static List<Auth> testlist = null;

    public HTTPCachingProvider(HTTPAuthStore store) {
        this.store = store;
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope scope) {
        Credentials credentials;
        if (TESTING) {
            System.err.println("HTTPCachingProvider.getCredentials,arg " + scope.toString());
            System.err.flush();
        }
        if ((credentials = HTTPCachingProvider.checkCache(scope)) != null) {
            if (TESTING) {
                System.err.println("Using cached credentials: " + credentials);
            }
            return credentials;
        }
        if (TESTING) {
            System.err.println("Credentials not cached");
        }
        String scheme = scope.getScheme();
        try {
            if (scheme == null) {
                throw new InvalidCredentialsException("HTTPCachingProvider: null scope scheme: " + scope);
            }
            CredentialsProvider cp = this.store.lookup(scope);
            if (cp == null) {
                throw new InvalidCredentialsException("HTTPCachingProvider: no credentialsprovider that match Authorization scope:" + scope);
            }
            credentials = cp.getCredentials(scope);
            if (credentials == null) {
                throw new InvalidCredentialsException("HTTPCachingProvider: cannot obtain credentials");
            }
            HTTPCachingProvider.cacheCredentials(scope, credentials);
            if (TESTING) {
                System.err.println("Caching credentials: " + credentials);
            }
            return credentials;
        }
        catch (InvalidCredentialsException ice) {
            HTTPSession.log.debug(ice.getMessage());
            return null;
        }
    }

    @Override
    public void setCredentials(AuthScope scope, Credentials creds) {
        HTTPCachingProvider.cacheCredentials(scope, creds);
    }

    @Override
    public void clear() {
        cache.clear();
    }

    public String toString() {
        return "HTTPCachingProvider";
    }

    protected static synchronized Credentials cacheCredentials(AuthScope scope, Credentials creds) {
        Auth p = null;
        Credentials old = null;
        for (Auth t : cache) {
            if (!t.scope.equals(scope)) continue;
            p = t;
            break;
        }
        if (p != null) {
            old = p.creds;
            p.creds = creds;
        } else {
            p = new Auth(scope, creds);
            cache.add(p);
        }
        return old;
    }

    protected static synchronized Credentials checkCache(AuthScope scope) {
        Credentials creds = null;
        for (Auth p : cache) {
            if (!HTTPAuthUtil.equals(p.scope, scope)) continue;
            creds = p.creds;
            break;
        }
        return creds;
    }

    public static synchronized void invalidate(AuthScope scope) {
        if (TESTING && testlist == null) {
            testlist = new ArrayList<Auth>();
        }
        for (int i = cache.size() - 1; i >= 0; --i) {
            Auth p = cache.get(i);
            if (!HTTPAuthUtil.equals(scope, p.scope)) continue;
            if (TESTING) {
                System.err.println("invalidating: " + p);
                if (testlist == null) {
                    testlist = new ArrayList<Auth>();
                }
                testlist.add(p);
            }
            cache.remove(i);
        }
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static synchronized List<Auth> getCache() {
        ArrayList<Auth> localcache = new ArrayList<Auth>();
        for (Auth p : cache) {
            Auth newp = new Auth(p.scope, p.creds);
            localcache.add(newp);
        }
        return localcache;
    }

    public static synchronized List<Auth> getTestList() {
        ArrayList<Auth> list = new ArrayList<Auth>();
        list.addAll(testlist);
        if (testlist != null) {
            testlist.clear();
        }
        return list;
    }

    public static class Auth {
        public AuthScope scope;
        public Credentials creds;

        public Auth(AuthScope scope, Credentials creds) {
            this.scope = scope;
            this.creds = creds;
        }

        public String toString() {
            return "(" + this.scope.toString() + "," + this.creds.toString() + ")";
        }
    }
}

