/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_1_0.WcsException;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.CFGridWriter2;
import ucar.nc2.util.DiskCache2;

public class GetCoverage {
    private static Logger log = LoggerFactory.getLogger(GetCoverage.class);
    protected static final Namespace owcsNS = Namespace.getNamespace("http://www.opengis.net/wcs/1.1/ows");
    protected static final Namespace owsNS = Namespace.getNamespace("ows", "http://www.opengis.net/ows");
    protected static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    private URI serverURI;
    private String identifier;
    private String version = "1.1.0";
    private String datasetPath;
    private GridDataset dataset;
    private Document getCoverageDoc;
    private boolean dataOnlyRequest = true;
    private static DiskCache2 diskCache = null;

    public GetCoverage(URI serverURI, String identifier, String datasetPath, GridDataset dataset) {
        this.serverURI = serverURI;
        this.identifier = identifier;
        this.datasetPath = datasetPath;
        this.dataset = dataset;
        if (this.serverURI == null) {
            throw new IllegalArgumentException("Non-null server URI required.");
        }
        if (this.identifier == null) {
            throw new IllegalArgumentException("Non-null coverage identifier required.");
        }
        if (this.datasetPath == null) {
            throw new IllegalArgumentException("Non-null dataset path required.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public boolean isDataOnlyRequest() {
        return this.dataOnlyRequest;
    }

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            log.error("getDiskCache(): Disk cache has not been set.");
            throw new IllegalStateException("Disk cache must be set before calling GetCoverage.getDiskCache().");
        }
        return diskCache;
    }

    public File writeCoverageDataToFile() throws WcsException {
        try {
            File dir = new File(GetCoverage.getDiskCache().getRootDirectory());
            File outFile = File.createTempFile("WCS", ".nc", dir);
            if (log.isDebugEnabled()) {
                log.debug("writeCoverageDataToFile(): ncFile=" + outFile.getPath());
            }
            NetcdfFileWriter writer = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, outFile.getAbsolutePath());
            CFGridWriter2.writeFile(this.dataset, Collections.singletonList(this.identifier), null, null, 1, null, null, 1, true, writer);
            return outFile;
        }
        catch (InvalidRangeException e) {
            log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.identifier + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.UnsupportedCombination, "", "Failed to subset coverage <" + this.identifier + ">.");
        }
        catch (IOException e) {
            log.error("writeCoverageDataToFile(): Failed to write file for requested coverage <" + this.identifier + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.NoApplicableCode, "", "Problem creating coverage <" + this.identifier + ">.");
        }
    }

    public Document getGetCoverageDoc() {
        if (this.getCoverageDoc == null) {
            this.getCoverageDoc = this.generateGetCoverageDoc();
        }
        return this.getCoverageDoc;
    }

    public void writeGetCoverageDoc(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getGetCoverageDoc(), (Writer)pw);
    }

    public Document generateGetCoverageDoc() {
        Element coveragesElem = new Element("Coverages", owcsNS);
        coveragesElem.addNamespaceDeclaration(owsNS);
        coveragesElem.addNamespaceDeclaration(xlinkNS);
        coveragesElem.addContent(this.genCoverage(this.identifier));
        return new Document(coveragesElem);
    }

    public Element genCoverage(String covId) {
        Element covDescripElem = new Element("Coverage", owcsNS);
        return covDescripElem;
    }
}

