/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import thredds.crawlabledataset.S3URI;
import thredds.crawlabledataset.ThreddsS3Client;

public class CachingThreddsS3Client
implements ThreddsS3Client {
    private static final long ENTRY_EXPIRATION_TIME = 600L;
    private static final long MAX_ENTRIES = 100L;
    private final ThreddsS3Client threddsS3Client;
    private final Cache<S3URI, ObjectMetadata> objectMetadataCache;
    private final Cache<S3URI, ObjectListing> objectListingCache;
    private final Cache<S3URI, File> objectFileCache;
    private static final ObjectMetadata emptyObjectMetadata = new ObjectMetadata();
    private static final ObjectListing emptyObjectListing = new ObjectListing();
    private static final File emptyFile = new File("");

    public CachingThreddsS3Client(ThreddsS3Client threddsS3Client) {
        this.threddsS3Client = threddsS3Client;
        this.objectMetadataCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(100L).build();
        this.objectListingCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(100L).build();
        this.objectFileCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(100L).removalListener(new ObjectFileCacheRemovalListener()).build();
    }

    @Override
    public ObjectMetadata getObjectMetadata(S3URI s3uri) {
        ObjectMetadata metadata = this.objectMetadataCache.getIfPresent(s3uri);
        if (metadata == emptyObjectMetadata) {
            return null;
        }
        if (metadata != null) {
            return metadata;
        }
        metadata = this.threddsS3Client.getObjectMetadata(s3uri);
        if (metadata == null) {
            this.objectMetadataCache.put(s3uri, emptyObjectMetadata);
        } else {
            this.objectMetadataCache.put(s3uri, metadata);
        }
        return metadata;
    }

    @Override
    public ObjectListing listObjects(S3URI s3uri) {
        ObjectListing objectListing = this.objectListingCache.getIfPresent(s3uri);
        if (objectListing == emptyObjectListing) {
            return null;
        }
        if (objectListing != null) {
            return objectListing;
        }
        objectListing = this.threddsS3Client.listObjects(s3uri);
        if (objectListing == null) {
            this.objectListingCache.put(s3uri, emptyObjectListing);
        } else {
            this.objectListingCache.put(s3uri, objectListing);
        }
        return objectListing;
    }

    @Override
    public File saveObjectToFile(S3URI s3uri, File file) throws IOException {
        File cachedFile = this.objectFileCache.getIfPresent(s3uri);
        if (cachedFile == emptyFile) {
            return null;
        }
        if (cachedFile != null) {
            if (!cachedFile.exists()) {
                this.objectFileCache.invalidate(s3uri);
            } else {
                if (cachedFile.equals(file)) {
                    return cachedFile;
                }
                Files.copy(cachedFile, file);
                this.objectFileCache.put(s3uri, file);
                return file;
            }
        }
        assert (cachedFile == null);
        if ((file = this.threddsS3Client.saveObjectToFile(s3uri, file)) == null) {
            this.objectFileCache.put(s3uri, emptyFile);
        } else {
            this.objectFileCache.put(s3uri, file);
        }
        return file;
    }

    private static class ObjectFileCacheRemovalListener
    implements RemovalListener<S3URI, File> {
        private ObjectFileCacheRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<S3URI, File> notification) {
            notification.getValue().delete();
        }
    }
}

