/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyHashSet<T> {
    private Set<T> set;
    private T single;

    public TinyHashSet() {
    }

    public TinyHashSet(T o) {
        this.single = o;
    }

    public int size() {
        if (this.single != null) {
            return 1;
        }
        if (this.set != null) {
            return this.set.size();
        }
        return 0;
    }

    public boolean contains(T o) {
        assert (this.single == null || this.set == null);
        if (this.single != null) {
            return this.single == o || this.single.equals(o);
        }
        if (this.set != null) {
            return this.set.contains(o);
        }
        return false;
    }

    public boolean remove(T o) {
        assert (this.single == null || this.set == null);
        if (this.single != null) {
            if (this.single == o || this.single.equals(o)) {
                this.single = null;
                return true;
            }
            return false;
        }
        if (this.set != null) {
            return this.set.remove(o);
        }
        return false;
    }

    public boolean add(T o) {
        assert (this.single == null || this.set == null);
        if (this.set != null) {
            return this.set.add(o);
        }
        if (this.single == null) {
            this.single = o;
            return true;
        }
        this.set = new HashSet<T>();
        this.set.add(this.single);
        this.single = null;
        return this.set.add(o);
    }

    public Set<T> copy() {
        assert (this.single == null || this.set == null);
        if (this.set != null) {
            return new HashSet<T>(this.set);
        }
        HashSet<T> ret = new HashSet<T>();
        if (this.single != null) {
            ret.add(this.single);
        }
        return ret;
    }

    public Iterator<T> iterator() {
        assert (this.single == null || this.set == null);
        if (this.set != null) {
            return this.set.iterator();
        }
        return new SingleElementIterator<T>(this.single, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleElementIterator<T>
    implements Iterator<T> {
        T theObject;
        TinyHashSet<T> theSet;
        boolean returnedTheObject = false;

        SingleElementIterator(T o, TinyHashSet<T> theSet) {
            this.theObject = o;
            this.theSet = theSet;
            this.returnedTheObject = o == null;
        }

        @Override
        public boolean hasNext() {
            return !this.returnedTheObject;
        }

        @Override
        public T next() {
            if (this.returnedTheObject) {
                throw new NoSuchElementException();
            }
            this.returnedTheObject = true;
            return this.theObject;
        }

        @Override
        public void remove() {
            if (this.theObject == null || !this.returnedTheObject) {
                throw EnvironmentFailureException.unexpectedState();
            }
            this.theSet.remove(this.theObject);
        }
    }
}

