/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeT;
import ucar.nc2.jni.netcdf.SizeTByReference;

public class Nc4wrapper
implements Nc4prototypes {
    public static boolean TRACE;
    private static Logger log;
    static int counter;
    private Nc4prototypes nc4;

    protected static void trace(Object ret, String fcn, Object ... args) {
        if (!TRACE) {
            return;
        }
        StringBuilder sargs = new StringBuilder("(");
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (i > 0) {
                sargs.append(",");
            }
            sargs.append(o == null ? "null" : o.toString());
        }
        sargs.append(")");
        log.info(String.format("trace: %s ret=%s args=%s", fcn, ret.toString(), sargs.toString()));
    }

    protected static void err(String cc, int c) {
        log.error("Serial failure: " + cc + ": counter != " + c + "\n");
    }

    protected static void ce() {
        if (counter != 0) {
            Nc4wrapper.err("ce", 0);
        }
        counter = 1;
    }

    protected static void cx() {
        if (counter != 1) {
            Nc4wrapper.err("cx", 1);
        }
        counter = 0;
    }

    public Nc4wrapper(Nc4prototypes nc4) {
        this.nc4 = nc4;
    }

    @Override
    public synchronized String nc_inq_libvers() {
        String ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_libvers();
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_libvers", "-");
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    @Override
    public synchronized String nc_strerror(int ncerr) {
        String ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_strerror(ncerr);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_strerror", ncerr);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_open(String path, int mode, IntByReference ncidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_open(path, mode, ncidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_open", path, mode, ncidp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    @Override
    public synchronized int nc_close(int ncid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_close(ncid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_close", ncid);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_format(int ncid, IntByReference formatp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_format(ncid, formatp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_format", ncid, formatp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_format_extended(int ncid, IntByReference formatp, IntByReference modep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_format_extended(ncid, formatp, modep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_format_extended", ncid, formatp, modep);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_grps(int ncid, IntByReference numgrps, int[] ncids) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_grps(ncid, numgrps, ncids);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_grps", ncid, numgrps, ncids);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_grpname(int ncid, byte[] name) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_grpname(ncid, name);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_grpname", ncid, name);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_grpname_full(int ncid, SizeTByReference lenp, byte[] full_name) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_grpname_full(ncid, lenp, full_name);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_grpname_full", new Object[]{ncid, lenp, full_name});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_grpname_len(int ncid, SizeTByReference lenp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_grpname_len(ncid, lenp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_grpname_len", new Object[]{ncid, lenp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_ndims(int ncid, IntByReference ndimsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_ndims(ncid, ndimsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_ndims", ncid, ndimsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_unlimdims(int ncid, IntByReference nunlimdimsp, int[] unlimdimidsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_unlimdims(ncid, nunlimdimsp, unlimdimidsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_unlimdims", ncid, nunlimdimsp, unlimdimidsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_dimids(int ncid, IntByReference ndims, int[] dimids, int include_parents) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_dimids(ncid, ndims, dimids, include_parents);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_dimids", ncid, ndims, dimids, include_parents);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_dim(int ncid, int dimid, byte[] name, SizeTByReference lenp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_dim(ncid, dimid, name, lenp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_dim", new Object[]{ncid, dimid, name, lenp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_dimname(int ncid, int dimid, byte[] name) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_dimname(ncid, dimid, name);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_dimname", ncid, dimid, name);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_natts(int ncid, IntByReference nattsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_natts(ncid, nattsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_natts", ncid, nattsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_attname(int ncid, int varid, int attnum, byte[] name) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_attname(ncid, varid, attnum, name);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_attname", ncid, varid, attnum, name);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_atttype(int ncid, int varid, String name, IntByReference xtypep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_atttype(ncid, varid, name, xtypep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_atttype", ncid, varid, name, xtypep);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_attlen(int ncid, int varid, String name, SizeTByReference lenp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_attlen(ncid, varid, name, lenp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_attlen", new Object[]{ncid, varid, name, lenp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_double(int ncid, int varid, String name, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_double(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_double", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_float(int ncid, int varid, String name, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_float(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_float", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_int(int ncid, int varid, String name, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_int(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_int", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_uint(int ncid, int varid, String name, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_uint(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_uint", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_longlong(int ncid, int varid, String name, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_longlong(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_longlong", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_ulonglong(int ncid, int varid, String name, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_ulonglong(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_ulonglong", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_schar(int ncid, int varid, String name, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_schar(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_schar", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_uchar(int ncid, int varid, String name, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_uchar(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_uchar", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_ubyte(int ncid, int varid, String name, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_ubyte(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_ubyte", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_short(int ncid, int varid, String name, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_short(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_short", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_ushort(int ncid, int varid, String name, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_ushort(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_ushort", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_text(int ncid, int varid, String name, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_text(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_text", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att_string(int ncid, int varid, String name, String[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att_string(ncid, varid, name, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att_string", ncid, varid, name, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att(int ncid, int varid, String name, byte[] bbuff) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att(ncid, varid, name, bbuff);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att", ncid, varid, name, bbuff);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_nvars(int ncid, IntByReference nvarsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_nvars(ncid, nvarsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_nvars", ncid, nvarsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_varids(int ncid, IntByReference nvars, int[] varids) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_varids(ncid, nvars, varids);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_varids", ncid, nvars, varids);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var(int ncid, int varid, byte[] name, IntByReference xtypep, IntByReference ndimsp, int[] dimidsp, IntByReference nattsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var(ncid, varid, name, xtypep, ndimsp, dimidsp, nattsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var", ncid, varid, name, xtypep, ndimsp, dimidsp, nattsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_varid(int ncid, byte[] name, IntByReference varidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_varid(ncid, name, varidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_varid", ncid, name, varidp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_vardimid(int ncid, int varid, int[] dimidsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_vardimid(ncid, varid, dimidsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_vardimid", ncid, varid, dimidsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_varnatts(int ncid, int varid, IntByReference nattsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_varnatts(ncid, varid, nattsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_varnatts", ncid, varid, nattsp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_typeids(int ncid, IntByReference ntypes, int[] typeids) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_typeids(ncid, ntypes, typeids);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_typeids", ncid, ntypes, typeids);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_type(int ncid, int xtype, byte[] name, SizeTByReference sizep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_type(ncid, xtype, name, sizep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_type", new Object[]{ncid, xtype, name, sizep});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_user_type(int ncid, int xtype, byte[] name, SizeTByReference sizep, IntByReference baseType, SizeTByReference nfieldsp, IntByReference classp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_user_type(ncid, xtype, name, sizep, baseType, nfieldsp, classp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_user_type", new Object[]{ncid, xtype, name, sizep, baseType, nfieldsp, classp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_enum(int ncid, int xtype, byte[] name, IntByReference baseType, SizeTByReference base_sizep, SizeTByReference num_membersp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_enum(ncid, xtype, name, baseType, base_sizep, num_membersp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_enum", new Object[]{ncid, xtype, name, baseType, base_sizep, num_membersp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_enum_member(int ncid, int xtype, int idx, byte[] name, IntByReference value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_enum_member(ncid, xtype, idx, name, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_enum_member", ncid, xtype, idx, name, value);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_opaque(int ncid, int xtype, byte[] name, SizeTByReference sizep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_opaque(ncid, xtype, name, sizep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_opaque", new Object[]{ncid, xtype, name, sizep});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var(int ncid, int varid, byte[] buf) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var(ncid, varid, buf);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var", ncid, varid, buf);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_text(int ncid, int varid, byte[] op) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_text(ncid, varid, op);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_text", ncid, varid, op);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_schar(int ncid, int varid, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_schar(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_schar", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_ubyte(int ncid, int varid, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_ubyte(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_ubyte", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_short(int ncid, int varid, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_short(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_short", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_ushort(int ncid, int varid, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_ushort(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_ushort", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_int(int ncid, int varid, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_int(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_int", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_uint(int ncid, int varid, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_uint(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_uint", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_longlong(int ncid, int varid, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_longlong(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_longlong", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_ulonglong(int ncid, int varid, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_ulonglong(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_ulonglong", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_float(int ncid, int varid, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_float(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_float", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_double(int ncid, int varid, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_double(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_double", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_string(int ncid, int varid, String[] sarray) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_string(ncid, varid, sarray);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_string", ncid, varid, sarray);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1(int ncid, int varid, SizeT[] indexp, byte[] buf) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1(ncid, varid, indexp, buf);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1", new Object[]{ncid, varid, indexp, buf});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_text(int ncid, int varid, SizeT[] indexp, byte[] op) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_text(ncid, varid, indexp, op);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_text", new Object[]{ncid, varid, indexp, op});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_schar(int ncid, int varid, SizeT[] indexp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_schar(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_schar", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_ubyte(int ncid, int varid, SizeT[] indexp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_ubyte(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_ubyte", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_short(int ncid, int varid, SizeT[] indexp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_short(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_short", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_ushort(int ncid, int varid, SizeT[] indexp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_ushort(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_ushort", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_int(int ncid, int varid, SizeT[] indexp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_int(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_int", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_uint(int ncid, int varid, SizeT[] indexp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_uint(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_uint", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_longlong(int ncid, int varid, SizeT[] indexp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_longlong(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_longlong", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_ulonglong(int ncid, int varid, SizeT[] indexp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_ulonglong(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_ulonglong", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_float(int ncid, int varid, SizeT[] indexp, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_float(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_float", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_double(int ncid, int varid, SizeT[] indexp, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_double(ncid, varid, indexp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_double", new Object[]{ncid, varid, indexp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1_string(int ncid, int varid, SizeT[] indexp, String[] sarray) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1_string(ncid, varid, indexp, sarray);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1_string", new Object[]{ncid, varid, indexp, sarray});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] buf) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara(ncid, varid, startp, countp, buf);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara", new Object[]{ncid, varid, startp, countp, buf});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_uchar(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_uchar(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_uchar", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_schar(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_schar(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_schar", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_text(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_text(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_text", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_short(int ncid, int varid, SizeT[] startp, SizeT[] countp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_short(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_short", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_ushort(int ncid, int varid, SizeT[] startp, SizeT[] countp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_ushort(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_ushort", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_int(int ncid, int varid, SizeT[] startp, SizeT[] countp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_int(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_int", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_uint(int ncid, int varid, SizeT[] startp, SizeT[] countp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_uint(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_uint", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_longlong(int ncid, int varid, SizeT[] startp, SizeT[] countp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_longlong(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_longlong", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_ulonglong(int ncid, int varid, SizeT[] startp, SizeT[] countp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_ulonglong(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_ulonglong", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_float(int ncid, int varid, SizeT[] startp, SizeT[] countp, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_float(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_float", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_double(int ncid, int varid, SizeT[] startp, SizeT[] countp, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_double(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_double", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara_string(int ncid, int varid, SizeT[] startp, SizeT[] countp, String[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara_string(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara_string", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] buf) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars(ncid, varid, startp, countp, stridep, buf);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars", new Object[]{ncid, varid, startp, countp, stridep, buf});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_uchar(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_uchar(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_uchar", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_schar(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_schar(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_schar", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_text(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_text(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_text", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_short(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_short(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_short", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_ushort(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_ushort(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_ushort", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_int(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_int(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_int", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_uint(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_uint(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_uint", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_longlong(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_longlong(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_longlong", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_ulonglong(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_ulonglong(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_ulonglong", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_float(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_float(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_float", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_double(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_double(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_double", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars_string(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, String[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars_string(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars_string", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_set_default_format(int format, IntByReference old_formatp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_set_default_format(format, old_formatp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_set_default_format", format, old_formatp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_create(String path, int cmode, IntByReference ncidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_create(path, cmode, ncidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_create", path, cmode, ncidp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    @Override
    public synchronized int nc_enddef(int ncid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_enddef(ncid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_enddef   ", ncid);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    @Override
    public synchronized int nc_sync(int ncid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_sync(ncid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_sync     ", ncid);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_grp(int parent_ncid, String name, IntByReference new_ncid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_grp(parent_ncid, name, new_ncid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_grp ", parent_ncid, name, new_ncid);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_dim(int ncid, String name, SizeT len, IntByReference dimid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_dim(ncid, name, len, dimid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_dim", new Object[]{ncid, name, len, dimid});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_dimlen(int ncid, int dimid, SizeTByReference lenp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_dimlen(ncid, dimid, lenp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_dimlen", new Object[]{ncid, dimid, lenp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var(int ncid, String name, SizeT xtype, int ndims, int[] dimids, IntByReference varidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var(ncid, name, xtype, ndims, dimids, varidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var ", new Object[]{ncid, name, xtype, ndims, dimids, varidp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_compound(int ncid, SizeT size, String name, IntByReference typeidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_compound(ncid, size, name, typeidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_compound", new Object[]{ncid, size, name, typeidp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_insert_compound(int ncid, int typeid, String name, SizeT offset, int field_typeid) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_insert_compound(ncid, typeid, name, offset, field_typeid);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_insert_compound", new Object[]{ncid, typeid, name, offset, field_typeid});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_insert_array_compound(int ncid, int typeid, String name, SizeT offset, int field_typeid, int ndims, int[] dim_sizes) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_insert_array_compound(ncid, typeid, name, offset, field_typeid, ndims, dim_sizes);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_insert_array_compound", new Object[]{ncid, typeid, name, offset, field_typeid, ndims, dim_sizes});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_enum(int ncid, int base_typeid, String name, IntByReference typeidp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_enum(ncid, base_typeid, name, typeidp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_enum", ncid, base_typeid, name, typeidp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_insert_enum(int ncid, int enumid, String name, IntByReference value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_insert_enum(ncid, enumid, name, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_insert_enum", ncid, enumid, name, value);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_rename_grp(int grpid, String name) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_rename_grp(grpid, name);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_rename_grp", grpid, name);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var(int ncid, int varid, byte[] bbuff) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var(ncid, varid, bbuff);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var", ncid, varid, bbuff);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] bbuff) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara(ncid, varid, startp, countp, bbuff);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara", new Object[]{ncid, varid, startp, countp, bbuff});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_uchar(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_uchar(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_uchar", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_schar(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_schar(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_schar", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_text(int ncid, int varid, SizeT[] startp, SizeT[] countp, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_text(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_text", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_short(int ncid, int varid, SizeT[] startp, SizeT[] countp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_short(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_short", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_ushort(int ncid, int varid, SizeT[] startp, SizeT[] countp, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_ushort(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_ushort", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_int(int ncid, int varid, SizeT[] startp, SizeT[] countp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_int(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_int", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_uint(int ncid, int varid, SizeT[] startp, SizeT[] countp, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_uint(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_uint", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_longlong(int ncid, int varid, SizeT[] startp, SizeT[] countp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_longlong(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_longlong", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_ulonglong(int ncid, int varid, SizeT[] startp, SizeT[] countp, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_ulonglong(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_ulonglong", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_float(int ncid, int varid, SizeT[] startp, SizeT[] countp, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_float(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_float", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_double(int ncid, int varid, SizeT[] startp, SizeT[] countp, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_double(ncid, varid, startp, countp, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_double", new Object[]{ncid, varid, startp, countp, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara_string(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, String[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara_string(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara_string", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] bbuff) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars(ncid, varid, startp, countp, stridep, bbuff);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars", new Object[]{ncid, varid, startp, countp, stridep, bbuff});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_uchar(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_uchar(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_uchar", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_schar(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_schar(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_schar", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_text(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_text(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_text", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_short(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_short(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_short", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_ushort(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_ushort(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_ushort", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_int(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_int(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_int", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_uint(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_uint(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_uint", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_longlong(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_longlong(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_longlong", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_ulonglong(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_ulonglong(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_ulonglong", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_float(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_float(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_float", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_double(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_double(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_double", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars_string(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, String[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars_string(ncid, varid, startp, countp, stridep, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars_string", new Object[]{ncid, varid, startp, countp, stridep, ip});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_uchar(int ncid, int varid, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_uchar(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_uchar", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_schar(int ncid, int varid, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_schar(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_schar", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_text(int ncid, int varid, byte[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_text(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_text", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_short(int ncid, int varid, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_short(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_short", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_ushort(int ncid, int varid, short[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_ushort(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_ushort", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_int(int ncid, int varid, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_int(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_int", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_uint(int ncid, int varid, int[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_uint(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_uint", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_longlong(int ncid, int varid, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_longlong(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_longlong", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_ulonglong(int ncid, int varid, long[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_ulonglong(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_ulonglong", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_float(int ncid, int varid, float[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_float(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_float", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_double(int ncid, int varid, double[] ip) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_double(ncid, varid, ip);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_double", ncid, varid, ip);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var_string(int ncid, int varid, String[] op) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var_string(ncid, varid, op);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var_string", ncid, varid, op);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att(int ncid, int varid, String name, int xtype, SizeT len, byte[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att(ncid, varid, name, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att ", new Object[]{ncid, varid, name, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_string(int ncid, int varid, String attName, SizeT len, String[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_string(ncid, varid, attName, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_string", new Object[]{ncid, varid, attName, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_text(int ncid, int varid, String attName, SizeT len, byte[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_text(ncid, varid, attName, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_text", new Object[]{ncid, varid, attName, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_uchar(int ncid, int varid, String attName, int xtype, SizeT len, byte[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_uchar(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_uchar", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_schar(int ncid, int varid, String attName, int xtype, SizeT len, byte[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_schar(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_schar", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_short(int ncid, int varid, String attName, int xtype, SizeT len, short[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_short(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_short", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_ushort(int ncid, int varid, String attName, int xtype, SizeT len, short[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_ushort(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_ushort", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_int(int ncid, int varid, String attName, int xtype, SizeT len, int[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_int(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_int", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_uint(int ncid, int varid, String attName, int xtype, SizeT len, int[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_uint(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_uint", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_longlong(int ncid, int varid, String attName, int xtype, SizeT len, long[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_longlong(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_longlong", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_ulonglong(int ncid, int varid, String attName, int xtype, SizeT len, long[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_ulonglong(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_ulonglong", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_float(int ncid, int varid, String attName, int xtype, SizeT len, float[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_float(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_float", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att_double(int ncid, int varid, String attName, int xtype, SizeT len, double[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att_double(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att_double", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var_deflate(int ncid, int varid, int shuffle, int deflate, int deflate_level) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var_deflate(ncid, varid, shuffle, deflate, deflate_level);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var_deflate", ncid, varid, shuffle, deflate, deflate_level);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_deflate(int ncid, int varid, IntByReference shufflep, IntByReference deflatep, IntByReference deflate_levelp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_deflate(ncid, varid, shufflep, deflatep, deflate_levelp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_deflate", ncid, varid, shufflep, deflatep, deflate_levelp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_szip(int ncid, int varid, IntByReference options_maskp, IntByReference pixels_per_blockp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_szip(ncid, varid, options_maskp, pixels_per_blockp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_szip", ncid, varid, options_maskp, pixels_per_blockp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var_fletcher32(int ncid, int varid, int fletcher32) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var_fletcher32(ncid, varid, fletcher32);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var_fletcher32", ncid, varid, fletcher32);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_fletcher32(int ncid, int varid, IntByReference fletcher32p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_fletcher32(ncid, varid, fletcher32p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_fletcher32", ncid, varid, fletcher32p);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var_chunking(int ncid, int varid, int storage, SizeT[] chunksizesp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var_chunking(ncid, varid, storage, chunksizesp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var_chunking", new Object[]{ncid, varid, storage, chunksizesp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_chunking(int ncid, int varid, IntByReference storagep, SizeT[] chunksizesp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_chunking(ncid, varid, storagep, chunksizesp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_chunking", new Object[]{ncid, varid, storagep, chunksizesp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var_fill(int ncid, int varid, int no_fill, byte[] fill_value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var_fill(ncid, varid, no_fill, fill_value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var_fill", ncid, varid, no_fill, fill_value);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_fill(int ncid, int varid, IntByReference no_fill, byte[] fill_valuep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_fill(ncid, varid, no_fill, fill_valuep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_fill", ncid, varid, no_fill, fill_valuep);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_def_var_endian(int ncid, int varid, int endian) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_def_var_endian(ncid, varid, endian);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_def_var_endian", ncid, varid, endian);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_var_endian(int ncid, int varid, IntByReference endianp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_var_endian(ncid, varid, endianp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_var_endian", ncid, varid, endianp);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_set_fill(int ncid, int fillmode, IntByReference old_modep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_set_fill(ncid, fillmode, old_modep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_set_fill", ncid, fillmode, old_modep);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_set_chunk_cache(SizeT size, SizeT nelems, float preemption) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_set_chunk_cache(size, nelems, preemption);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_set_chunk_cache", new Object[]{size, nelems, Float.valueOf(preemption)});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_chunk_cache(SizeTByReference sizep, SizeTByReference nelemsp, FloatByReference preemptionp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_chunk_cache(sizep, nelemsp, preemptionp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_chunk_cache", new Object[]{sizep, nelemsp, preemptionp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_set_var_chunk_cache(int ncid, int varid, SizeT size, SizeT nelems, float preemption) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_set_var_chunk_cache(ncid, varid, size, nelems, preemption);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_set_var_chunk_cache", new Object[]{ncid, varid, size, nelems, Float.valueOf(preemption)});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var_chunk_cache(int ncid, int varid, SizeTByReference sizep, SizeTByReference nelemsp, FloatByReference preemptionp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var_chunk_cache(ncid, varid, sizep, nelemsp, preemptionp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var_chunk_cache", new Object[]{ncid, varid, sizep, nelemsp, preemptionp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    @Override
    public synchronized int nc_set_log_level(int newlevel) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_set_log_level(newlevel);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_set_log_level", newlevel);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_compound(int ncid, int xtype, byte[] name, SizeTByReference sizep, SizeTByReference nfieldsp) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_compound(ncid, xtype, name, sizep, nfieldsp);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_compound", new Object[]{ncid, xtype, name, sizep, nfieldsp});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_compound_field(int ncid, int xtype, int fieldid, byte[] name, SizeTByReference offsetp, IntByReference field_typeidp, IntByReference ndimsp, int[] dims) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_compound_field(ncid, xtype, fieldid, name, offsetp, field_typeidp, ndimsp, dims);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_compound_field", new Object[]{ncid, xtype, fieldid, name, offsetp, field_typeidp, ndimsp, dims});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_inq_vlen(int ncid, int xtype, byte[] name, SizeTByReference datum_sizep, IntByReference base_nc_typep) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_inq_vlen(ncid, xtype, name, datum_sizep, base_nc_typep);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_inq_vlen", new Object[]{ncid, xtype, name, datum_sizep, base_nc_typep});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att(int ncid, int varid, String name, Nc4prototypes.Vlen_t[] vlen) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att(ncid, varid, name, vlen);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att", new Object[]{ncid, varid, name, vlen});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var(int ncid, int varid, Nc4prototypes.Vlen_t[] vlen) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var(ncid, varid, vlen);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var", new Object[]{ncid, varid, vlen});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1(int ncid, int varid, SizeT[] indexp, Nc4prototypes.Vlen_t[] vlen) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1(ncid, varid, indexp, vlen);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1", new Object[]{ncid, varid, indexp, vlen});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, Nc4prototypes.Vlen_t[] v) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara(ncid, varid, startp, countp, v);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara", new Object[]{ncid, varid, startp, countp, v});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, Nc4prototypes.Vlen_t[] v) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars(ncid, varid, startp, countp, stridep, v);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars", new Object[]{ncid, varid, startp, countp, stridep, v});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att(int ncid, int varid, String attName, int xtype, SizeT len, Nc4prototypes.Vlen_t[] value) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att(ncid, varid, attName, xtype, len, value);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att", new Object[]{ncid, varid, attName, xtype, len, value});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var(int ncid, int varid, Nc4prototypes.Vlen_t[] vlen) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var(ncid, varid, vlen);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var", new Object[]{ncid, varid, vlen});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var1(int ncid, int varid, SizeT[] indexp, Nc4prototypes.Vlen_t[] vlen) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var1(ncid, varid, indexp, vlen);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var1", new Object[]{ncid, varid, indexp, vlen});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, Nc4prototypes.Vlen_t[] v) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara(ncid, varid, startp, countp, v);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara", new Object[]{ncid, varid, startp, countp, v});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, Nc4prototypes.Vlen_t[] v) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars(ncid, varid, startp, countp, stridep, v);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars", new Object[]{ncid, varid, startp, countp, stridep, v});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_att(int ncid, int varid, String name, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_att(ncid, varid, name, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_att", ncid, varid, name, p);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var(int ncid, int varid, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var(ncid, varid, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var", ncid, varid, p);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_var1(int ncid, int varid, SizeT[] indexp, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_var1(ncid, varid, indexp, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_var1", new Object[]{ncid, varid, indexp, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vara(ncid, varid, startp, countp, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vara", new Object[]{ncid, varid, startp, countp, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_get_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_get_vars(ncid, varid, startp, countp, stridep, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_get_vars", new Object[]{ncid, varid, startp, countp, stridep, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_att(int ncid, int varid, String attName, int xtype, SizeT len, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_att(ncid, varid, attName, xtype, len, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_att", new Object[]{ncid, varid, attName, xtype, len, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var(int ncid, int varid, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var(ncid, varid, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var", ncid, varid, p);
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_var1(int ncid, int varid, SizeT[] indexp, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_var1(ncid, varid, indexp, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_var1", new Object[]{ncid, varid, indexp, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vara(int ncid, int varid, SizeT[] startp, SizeT[] countp, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vara(ncid, varid, startp, countp, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vara", new Object[]{ncid, varid, startp, countp, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nc_put_vars(int ncid, int varid, SizeT[] startp, SizeT[] countp, SizeT[] stridep, Pointer p) {
        int ret;
        try {
            Nc4wrapper.ce();
            ret = this.nc4.nc_put_vars(ncid, varid, startp, countp, stridep, p);
            if (TRACE) {
                Nc4wrapper.trace(ret, "nc_put_vars", new Object[]{ncid, varid, startp, countp, stridep, p});
            }
        }
        finally {
            Nc4wrapper.cx();
        }
        return ret;
    }

    static {
        log = LoggerFactory.getLogger(Nc4wrapper.class);
    }
}

