/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.rewrite;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.jni.netcdf.Nc4Iosp;

public class Rewrite {
    NetcdfFile ncIn;
    NetcdfFileWriter ncOut;
    NetcdfFileWriter.Version version;
    private int anon = 0;

    Rewrite(NetcdfFile ncIn, NetcdfFileWriter ncOut) {
        this.ncIn = ncIn;
        this.ncOut = ncOut;
        this.version = ncOut.getVersion();
    }

    void rewrite() throws IOException, InvalidRangeException {
        this.createGroup(null, this.ncIn.getRootGroup());
        this.ncOut.create();
        this.transferData(this.ncIn.getRootGroup());
        this.ncOut.close();
    }

    void createGroup(Group newParent, Group oldGroup) throws IOException, InvalidRangeException {
        Group newGroup = this.ncOut.addGroup(newParent, oldGroup.getShortName());
        for (Attribute att : oldGroup.getAttributes()) {
            newGroup.addAttribute(att);
        }
        for (Dimension dim : oldGroup.getDimensions()) {
            this.ncOut.addDimension(newGroup, dim.getShortName(), dim.getLength(), true, dim.isUnlimited(), dim.isVariableLength());
        }
        for (Variable v : oldGroup.getVariables()) {
            Variable nv;
            List dims = v.getDimensions();
            for (Dimension dim : dims) {
                if (dim.isShared()) continue;
                dim.setName("anon" + this.anon);
                dim.setShared(true);
                ++this.anon;
                this.ncOut.addDimension(newGroup, dim.getShortName(), dim.getLength(), true, dim.isUnlimited(), dim.isVariableLength());
            }
            if (v.getRank() >= 3) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < dims.size(); ++i) {
                    sb.append(((Dimension)dims.get(i)).getShortName()).append(" ");
                }
                sb.append(((Dimension)dims.get(0)).getShortName());
                nv = this.ncOut.addVariable(null, v.getShortName(), v.getDataType(), sb.toString());
            } else {
                nv = this.ncOut.addVariable(null, v.getShortName(), v.getDataType(), v.getDimensionsString());
            }
            for (Attribute att : v.getAttributes()) {
                this.ncOut.addVariableAttribute(nv, att);
            }
        }
        for (Group g : oldGroup.getGroups()) {
            this.createGroup(newGroup, g);
        }
    }

    void transferData(Group oldGroup) throws IOException, InvalidRangeException {
        for (Variable v : oldGroup.getVariables()) {
            if (v.getRank() >= 3) {
                this.invertOneVar(v);
                continue;
            }
            System.out.printf("write %s%n", v.getNameAndDimensions());
            Array data = v.read();
            Variable nv = this.ncOut.findVariable(v.getFullName());
            this.ncOut.write(nv, data);
        }
        for (Group g : oldGroup.getGroups()) {
            this.transferData(g);
        }
    }

    void invertOneVar(Variable oldVar) throws IOException, InvalidRangeException {
        System.out.printf("invertOneVar %s%n", oldVar.getNameAndDimensions());
        int rank = oldVar.getRank();
        int[] origin = new int[rank];
        int[] shape = oldVar.getShape();
        Variable nv = this.ncOut.findVariable(oldVar.getFullName());
        Cache cache = new Cache(shape, nv.getShape(), oldVar.getDataType());
        int nt = shape[0];
        for (int k = 0; k < nt; ++k) {
            shape[0] = 1;
            origin[0] = k;
            Array data = oldVar.read(origin, shape);
            cache.transfer(data.reduce(), k);
        }
        cache.write(nv);
    }

    public static void main(String[] arg) throws IOException, InvalidRangeException {
        Nc4Iosp.setLibraryAndPath("C:\\netcdfc\\netCDF 4.3.0-rc4\\bin", "netcdf");
        long start = System.nanoTime();
        boolean netcdf4 = false;
        String datasetIn = "E:/data/nomads/problem/soilt1.gdas.200603.grb2";
        String datasetOut = "C:/temp/soilt1.gdas.200603.nc3";
        NetcdfFile ncfileIn = NetcdfDataset.openFile((String)datasetIn, null);
        System.out.printf("Read from %s write to %s%n", datasetIn, datasetOut);
        NetcdfFileWriter.Version version = netcdf4 ? NetcdfFileWriter.Version.netcdf4 : NetcdfFileWriter.Version.netcdf3;
        NetcdfFileWriter ncOut = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)version, (String)datasetOut);
        Rewrite rewrite = new Rewrite(ncfileIn, ncOut);
        rewrite.rewrite();
        ncfileIn.close();
        File oldFile = new File(datasetIn);
        File newFile = new File(datasetOut);
        double r = (double)newFile.length() / (double)oldFile.length();
        double took = (double)(System.nanoTime() - start) / 1000.0 / 1000.0 / 1000.0;
        System.out.printf("that took %f secs %n", took);
        System.out.printf("%nRewrite from %s (%d) to %s (%d) version = %s ratio = %f %n", datasetIn, oldFile.length(), datasetOut, newFile.length(), version, r);
    }

    private class Cache {
        int[] shape;
        int[] newshape;
        int nt;
        int chunksize;
        Array result;
        Array work;
        int counter = 0;

        Cache(int[] shape, int[] newshape, DataType dataType) {
            this.shape = shape;
            this.newshape = newshape;
            this.result = Array.factory((DataType)dataType, (int[])newshape);
            this.nt = shape[0];
            Section s = new Section(shape);
            this.chunksize = (int)(s.computeSize() / (long)this.nt);
            int[] reshape = new int[]{this.chunksize, this.nt};
            this.work = this.result.reshapeNoCopy(reshape);
        }

        void transfer(Array slice, int k) {
            Index ima = this.work.getIndex();
            ima.set1(k);
            int count = 0;
            IndexIterator ii = slice.getIndexIterator();
            while (ii.hasNext()) {
                this.work.setDouble(ima.set0(count), ii.getDoubleNext());
                ++count;
            }
        }

        void write(Variable newVar) throws IOException, InvalidRangeException {
            Rewrite.this.ncOut.write(newVar, this.result);
        }
    }
}

