/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import thredds.catalog.InvDataset;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectGeoRegion;
import thredds.catalog.query.SelectRangeDate;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.StationObsDatatypeImpl;
import ucar.nc2.dt.point.decode.MetarParseReport;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public class DqcStationObsDataset
extends StationObsDatasetImpl {
    private QueryCapability dqc;
    private SelectService selService;
    private SelectStation selStation;
    private SelectRangeDate selDate;
    private SelectGeoRegion selRegion;
    private SelectService.ServiceChoice service;
    private boolean debugQuery = false;
    private StructureMembers members;
    private MetarParseReport parser;

    public static DqcStationObsDataset factory(InvDataset ds, String dqc_location, StringBuilder errlog) throws IOException {
        return DqcStationObsDataset.factory(ds.getDocumentation("summary"), dqc_location, errlog);
    }

    public static DqcStationObsDataset factory(String desc, String dqc_location, StringBuilder errlog) throws IOException {
        DqcFactory dqcFactory = new DqcFactory(true);
        QueryCapability dqc = dqcFactory.readXML(dqc_location);
        if (dqc.hasFatalError()) {
            errlog.append(dqc.getErrorMessages());
            return null;
        }
        SelectStation selStation = null;
        SelectRangeDate selDate = null;
        SelectService selService = null;
        SelectGeoRegion selRegion = null;
        ArrayList selectors = dqc.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s = (Selector)selectors.get(i);
            if (s instanceof SelectStation) {
                selStation = (SelectStation)s;
            }
            if (s instanceof SelectRangeDate) {
                selDate = (SelectRangeDate)s;
            }
            if (s instanceof SelectService) {
                selService = (SelectService)s;
            }
            if (!(s instanceof SelectGeoRegion)) continue;
            selRegion = (SelectGeoRegion)s;
        }
        if (selService == null) {
            errlog.append("DqcStationObsDataset must have Service selector");
            return null;
        }
        if (selStation == null) {
            errlog.append("DqcStationObsDataset must have Station selector");
            return null;
        }
        if (selDate == null) {
            errlog.append("DqcStationObsDataset must have Date selector");
            return null;
        }
        if (selRegion == null) {
            errlog.append("DqcStationObsDataset must have GeoRegion selector");
            return null;
        }
        SelectService.ServiceChoice wantServiceChoice = null;
        ArrayList services = selService.getChoices();
        for (int i = 0; i < services.size(); ++i) {
            SelectService.ServiceChoice serviceChoice = (SelectService.ServiceChoice)services.get(i);
            if (!serviceChoice.getService().equals("HTTPServer") || !serviceChoice.getDataFormat().equals("text/plain") || !serviceChoice.getReturns().equals("data")) continue;
            wantServiceChoice = serviceChoice;
        }
        if (wantServiceChoice == null) {
            errlog.append("DqcStationObsDataset must have HTTPServer Service with DataFormat=text/plain, and returns=data");
            return null;
        }
        return new DqcStationObsDataset(desc, dqc, selService, wantServiceChoice, selStation, selRegion, selDate);
    }

    private DqcStationObsDataset(String desc, QueryCapability dqc, SelectService selService, SelectService.ServiceChoice service, SelectStation selStation, SelectGeoRegion selRegion, SelectRangeDate selDate) {
        this.desc = desc;
        this.dqc = dqc;
        this.selService = selService;
        this.selStation = selStation;
        this.selRegion = selRegion;
        this.selDate = selDate;
        this.service = service;
        ArrayList stationList = selStation.getStations();
        for (int i = 0; i < stationList.size(); ++i) {
            Station station = (Station)stationList.get(i);
            this.stations.add(new DqcStation(station));
        }
        this.startDate = new Date();
        this.endDate = new Date();
        try {
            this.timeUnit = new DateUnit("hours since 1991-01-01T00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parser = new MetarParseReport();
        this.members = new StructureMembers("fake");
        this.members.addMember("line", null, null, DataType.STRING, new int[]{1});
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
    }

    @Override
    public String getTitle() {
        return this.dqc.getName();
    }

    @Override
    public String getLocation() {
        return this.dqc.getCreateFrom();
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public List getData(ucar.unidata.geoloc.Station s, CancelTask cancel) throws IOException {
        return ((DqcStation)s).getObservations();
    }

    private ArrayList makeQuery(ucar.unidata.geoloc.Station s) throws IOException {
        StringBuffer queryb = new StringBuffer();
        queryb.append(this.dqc.getQuery().getUriResolved().toString());
        ArrayList<String> choices = new ArrayList<String>();
        queryb.append("returns=text&dtime=3day&");
        choices.clear();
        choices.add("{value}");
        choices.add(s.getName());
        this.selStation.appendQuery(queryb, choices);
        String queryString = queryb.toString();
        if (this.debugQuery) {
            System.out.println("dqc makeQuery= " + queryString);
        }
        return this.readText(s, queryString);
    }

    private ArrayList readText(ucar.unidata.geoloc.Station s, String urlString) throws IOException {
        URL url;
        ArrayList<DqcObsImpl> obsList = new ArrayList<DqcObsImpl>();
        System.out.println("readText= " + urlString);
        InputStream is = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            String line;
            HttpURLConnection httpConnection;
            int responseCode;
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            boolean first = true;
            is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (first) {
                    this.show(line);
                }
                first = false;
                obsList.add(new DqcObsImpl(s, 0.0, line));
            }
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return obsList;
    }

    private void show(String line) {
        System.out.println(line);
        if (!this.parser.parseReport(line)) {
            return;
        }
        LinkedHashMap map = this.parser.getFields();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            System.out.println(" " + key + "==(" + value + ") ");
        }
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return null;
    }

    @Override
    public int getDataCount() {
        return -1;
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    public static void main(String[] args) throws IOException {
        StringBuilder errlog = new StringBuilder();
        String dqc_location = "file:///C:/data/dqc/metarNew.xml";
        DqcStationObsDataset ds = DqcStationObsDataset.factory("test", dqc_location, errlog);
        System.out.println(" errs= " + errlog);
        List<ucar.unidata.geoloc.Station> stns = ds.getStations();
        System.out.println(" nstns= " + stns.size());
        ucar.unidata.geoloc.Station stn = stns.get(13);
        List data = ds.getData(stn, null);
        for (int i = 0; i < data.size(); ++i) {
            StationObsDatatypeImpl obs = (StationObsDatatypeImpl)data.get(i);
            StructureData sdata = obs.getData();
            System.out.println(i + " " + sdata.getScalarString("line"));
        }
    }

    public class DqcObsImpl
    extends StationObsDatatypeImpl {
        String[] lineData;
        StructureDataW sdata;

        private DqcObsImpl(ucar.unidata.geoloc.Station station, double dateValue, String line) {
            super(station, dateValue, dateValue);
            this.lineData = new String[1];
            this.lineData[0] = line;
        }

        @Override
        public StructureData getData() throws IOException {
            if (this.sdata == null) {
                this.sdata = new StructureDataW(DqcStationObsDataset.this.members);
                Array array = Array.factory(String.class, new int[]{1}, (Object)this.lineData);
                this.sdata.setMemberData("line", array);
            }
            return this.sdata;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return DqcStationObsDataset.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return DqcStationObsDataset.this.timeUnit.makeDate(this.getObservationTime());
        }
    }

    private class DqcStation
    extends StationImpl {
        private DqcStation(Station s) {
            this.name = s.getValue();
            this.desc = s.getName();
            this.lat = s.getLocation().getLatitude();
            this.lon = s.getLocation().getLongitude();
            this.alt = s.getLocation().getElevation();
        }

        protected ArrayList readObservations() throws IOException {
            return DqcStationObsDataset.this.makeQuery((ucar.unidata.geoloc.Station)this);
        }
    }
}

