/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_1;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import thredds.wcs.v1_0_0_1.WcsCoverage;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;

public class WcsDataset {
    private String datasetPath;
    private String datasetName;
    private GridDataset dataset;
    private HashMap<String, WcsCoverage> availableCoverages;

    public WcsDataset(GridDataset dataset, String datasetPath) {
        this.datasetPath = datasetPath;
        int pos = datasetPath.lastIndexOf("/");
        this.datasetName = pos > 0 ? datasetPath.substring(pos + 1) : datasetPath;
        this.dataset = dataset;
        this.availableCoverages = new HashMap();
        for (GridDatatype curGridDatatype : this.dataset.getGrids()) {
            GridCoordSystem gcs = curGridDatatype.getCoordinateSystem();
            if (!gcs.isRegularSpatial()) continue;
            this.availableCoverages.put(curGridDatatype.getName(), new WcsCoverage(curGridDatatype, this));
        }
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public GridDataset getDataset() {
        return this.dataset;
    }

    public void close() throws IOException {
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    public boolean isAvailableCoverageName(String name) {
        return this.availableCoverages.containsKey(name);
    }

    public WcsCoverage getAvailableCoverage(String name) {
        return this.availableCoverages.get(name);
    }

    public Collection<WcsCoverage> getAvailableCoverageCollection() {
        return Collections.unmodifiableCollection(this.availableCoverages.values());
    }
}

