/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPUtil;

public class HTTPSession
implements Closeable {
    public static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    public static final String HANDLE_REDIRECTS = "http.protocol.handle-redirects";
    public static final String HANDLE_AUTHENTICATION = "http.protocol.handle-authentication";
    public static final String MAX_REDIRECTS = "http.protocol.max-redirects";
    public static final String SO_TIMEOUT = "http.socket.timeout";
    public static final String CONN_TIMEOUT = "http.connection.timeout";
    public static final String USER_AGENT = "http.useragent";
    public static final String COOKIE_STORE = "http.cookie-store";
    public static final String CONN_REQ_TIMEOUT = "http.connection_request.timeout";
    public static final String RETRIES = "http.retries";
    public static final String UNAVAILRETRIES = "http.service_unavailable";
    public static final String COMPRESSION = "COMPRESSION";
    public static final String CREDENTIALS = "Credentials";
    public static final String USESESSIONS = "UseSessions";
    public static final String HEADER_USERAGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    static final int DFALTTHREADCOUNT = 50;
    static final int DFALTREDIRECTS = 25;
    static final int DFALTCONNTIMEOUT = 60000;
    static final int DFALTCONNREQTIMEOUT = 60000;
    static final int DFALTSOTIMEOUT = 300000;
    static final int DFALTRETRIES = 3;
    static final int DFALTUNAVAILRETRIES = 3;
    static final int DFALTUNAVAILINTERVAL = 3000;
    static final String DFALTUSERAGENT = "/NetcdfJava/HttpClient4.4";
    static final String[] KNOWNCOMPRESSORS = new String[]{"gzip", "deflate"};
    static final boolean IGNORECERTS = false;
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    static PoolingHttpClientConnectionManager connmgr;
    static Settings globalsettings;
    static List<HttpRequestInterceptor> reqintercepts;
    static List<HttpResponseInterceptor> rspintercepts;
    protected static HttpResponseInterceptor CEKILL;
    protected static List<HttpRequestInterceptor> dbgreq;
    protected static List<HttpResponseInterceptor> dbgrsp;
    protected static Map<String, InputStreamFactory> contentDecoderMap;
    protected static Map<AuthScope, CredentialsProvider> globalcreds;
    protected static KeyStore keystore;
    protected static KeyStore truststore;
    protected static String keypath;
    protected static String keypassword;
    protected static String trustpath;
    protected static String trustpassword;
    protected static SSLConnectionSocketFactory globalsslfactory;
    protected static Registry<ConnectionSocketFactory> sslregistry;
    protected static HttpHost httpproxy;
    protected static HttpHost httpsproxy;
    protected static String proxyuser;
    protected static String proxypwd;
    protected static Boolean globaldebugheaders;
    protected String sessionURI = null;
    protected URI scopeURI = null;
    protected AuthScope scope = null;
    protected boolean closed = false;
    protected Map<AuthScope, CredentialsProvider> localcreds = new HashMap<AuthScope, CredentialsProvider>();
    protected List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    protected String identifier = "Session";
    protected Settings localsettings = new Settings();
    protected HttpClientContext sessioncontext = HttpClientContext.create();
    protected boolean cachevalid = false;
    protected CloseableHttpClient cachedclient = null;
    protected RequestConfig cachedconfig = null;
    protected URI requestURI = null;
    protected HttpUriRequest request = null;
    static List<HTTPSession> sessionList;
    public static boolean TESTING;

    protected static void setDefaults(Settings props) {
        props.setParameter(HANDLE_REDIRECTS, Boolean.TRUE);
        props.setParameter(ALLOW_CIRCULAR_REDIRECTS, Boolean.TRUE);
        props.setParameter(MAX_REDIRECTS, 25);
        props.setParameter(SO_TIMEOUT, 300000);
        props.setParameter(CONN_TIMEOUT, 60000);
        props.setParameter(USER_AGENT, DFALTUSERAGENT);
    }

    static synchronized void processDFlags() {
        keypath = HTTPSession.cleanproperty("keystore");
        keypassword = HTTPSession.cleanproperty("keystorepassword");
        trustpath = HTTPSession.cleanproperty("truststore");
        trustpassword = HTTPSession.cleanproperty("truststorepassword");
        HTTPSession.setGlobalSSLAuth(keypath, keypassword, trustpath, trustpassword);
        String proxyurl = HTTPSession.cleanproperty("proxyurl");
        if (proxyurl != null) {
            HTTPSession.setGlobalProxy(proxyurl);
        } else {
            String proxyhost = HTTPSession.cleanproperty("https.proxyHost");
            if (proxyhost != null) {
                StringBuilder buf = new StringBuilder();
                buf.append("https://");
                buf.append(proxyhost);
                String proxyport = HTTPSession.cleanproperty("https.proxyPort");
                if (proxyport != null) {
                    buf.append(":");
                    buf.append(proxyport);
                }
                HTTPSession.setGlobalProxy(buf.toString());
            }
        }
    }

    public static synchronized void setGlobalUserAgent(String userAgent) {
        globalsettings.setParameter(USER_AGENT, userAgent);
    }

    public static synchronized String getGlobalUserAgent() {
        return (String)globalsettings.getParameter(USER_AGENT);
    }

    public static synchronized void setGlobalThreadCount(int nthreads) {
        connmgr.setMaxTotal(nthreads);
        connmgr.setDefaultMaxPerRoute(nthreads);
    }

    public static void setGlobalMaxConnections(int nthreads) {
        HTTPSession.setGlobalThreadCount(nthreads);
    }

    public static synchronized int getGlobalThreadCount() {
        return connmgr.getMaxTotal();
    }

    public static synchronized void setGlobalConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(CONN_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalSoTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(SO_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalFollowRedirects(boolean tf) {
        globalsettings.setParameter(HANDLE_REDIRECTS, tf);
    }

    public static synchronized void setGlobalMaxRedirects(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setMaxRedirects");
        }
        globalsettings.setParameter(MAX_REDIRECTS, n);
    }

    public static synchronized Object getGlobalSetting(String key) {
        return globalsettings.get(key);
    }

    public static synchronized void setGlobalCompression(String compressors) {
        Object hrsi;
        String compresslist;
        if (globalsettings.getParameter(COMPRESSION) != null) {
            HTTPSession.removeGlobalCompression();
        }
        if (HTTPUtil.nullify(compresslist = HTTPSession.checkCompressors(compressors)) == null) {
            throw new IllegalArgumentException("Bad compressors: " + compressors);
        }
        globalsettings.setParameter(COMPRESSION, compresslist);
        if (compresslist.contains("gzip")) {
            hrsi = new GZIPResponseInterceptor();
            rspintercepts.add((HttpResponseInterceptor)hrsi);
        }
        if (compresslist.contains("deflate")) {
            hrsi = new DeflateResponseInterceptor();
            rspintercepts.add((HttpResponseInterceptor)hrsi);
        }
    }

    public static void removeGlobalCompression() {
        if (globalsettings.removeParameter(COMPRESSION) != null) {
            for (int i = rspintercepts.size() - 1; i >= 0; --i) {
                HttpResponseInterceptor hrsi = rspintercepts.get(i);
                if (!(hrsi instanceof GZIPResponseInterceptor) && !(hrsi instanceof DeflateResponseInterceptor)) continue;
                rspintercepts.remove(i);
            }
        }
    }

    protected static synchronized String checkCompressors(String compressors) {
        String[] pieces;
        HashSet<String> cset = new HashSet<String>();
        compressors = compressors.replace(',', ' ');
        compressors = compressors.replace('\t', ' ');
        block0: for (String p : pieces = compressors.split("[ ]+")) {
            for (String c : KNOWNCOMPRESSORS) {
                if (!p.equalsIgnoreCase(c)) continue;
                cset.add(c);
                continue block0;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (String s : cset) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static void setGlobalCredentialsProvider(CredentialsProvider provider) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider, (AuthScope)null);
    }

    public static void setGlobalCredentialsProvider(CredentialsProvider provider, AuthScope scope) throws HTTPException {
        HTTPSession.mapcreds(provider, scope, globalcreds);
    }

    public static void setGlobalCredentials(Credentials creds) throws HTTPException {
        HTTPSession.setGlobalCredentials(creds, null);
    }

    public static void setGlobalCredentials(Credentials creds, AuthScope scope) throws HTTPException {
        assert (creds != null);
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider, scope);
    }

    public static synchronized void setGlobalSSLAuth(String keypath, String keypassword, String trustpath, String trustpassword) {
        block34: {
            try {
                Throwable throwable;
                FileInputStream instream;
                if (trustpath != null && trustpassword != null) {
                    truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                    instream = new FileInputStream(new File(trustpath));
                    throwable = null;
                    try {
                        truststore.load(instream, trustpassword.toCharArray());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (instream != null) {
                            if (throwable != null) {
                                try {
                                    instream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                instream.close();
                            }
                        }
                    }
                } else {
                    truststore = null;
                }
                if (keypath != null && keypassword != null) {
                    keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    instream = new FileInputStream(new File(keypath));
                    throwable = null;
                    try {
                        keystore.load(instream, keypassword.toCharArray());
                        break block34;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (instream != null) {
                            if (throwable != null) {
                                try {
                                    instream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                instream.close();
                            }
                        }
                    }
                }
                keystore = null;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                log.error("Illegal -D keystore parameters: " + ex.getMessage());
                truststore = null;
                keystore = null;
            }
        }
        try {
            SSLContext scxt = null;
            SSLContextBuilder sslbuilder = SSLContexts.custom();
            LooseTrustStrategy strat = new LooseTrustStrategy();
            if (truststore != null) {
                sslbuilder.loadTrustMaterial(truststore, (TrustStrategy)strat);
            } else {
                sslbuilder.loadTrustMaterial((TrustStrategy)strat);
            }
            sslbuilder.loadTrustMaterial(truststore, (TrustStrategy)new LooseTrustStrategy());
            if (keystore != null) {
                sslbuilder.loadKeyMaterial(keystore, keypassword.toCharArray());
            }
            scxt = sslbuilder.build();
            globalsslfactory = new SSLConnectionSocketFactory(scxt, (HostnameVerifier)new NoopHostnameVerifier());
            RegistryBuilder rb = RegistryBuilder.create();
            rb.register("https", (Object)globalsslfactory);
            sslregistry = rb.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            log.error("Failed to set key/trust store(s): " + e.getMessage());
            sslregistry = null;
            globalsslfactory = null;
        }
    }

    public static synchronized void setGlobalProxy(String proxyurl) {
        URI uri;
        if (proxyurl == null) {
            throw new IllegalArgumentException("Bad proxy URL: " + proxyurl);
        }
        try {
            uri = HTTPUtil.parseToURI(proxyurl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad proxy URL: " + proxyurl);
        }
        if (uri.getScheme().equals("http")) {
            httpproxy = new HttpHost(uri.getHost(), uri.getPort(), "http");
        } else if (uri.getScheme().equals("https")) {
            httpsproxy = new HttpHost(uri.getHost(), uri.getPort(), "https");
        }
        String upw = uri.getUserInfo();
        if (upw != null) {
            String[] pieces = upw.split("[:]");
            if (pieces.length != 2 || HTTPUtil.nullify(pieces[0]) == null || HTTPUtil.nullify(pieces[1]) == null) {
                throw new IllegalArgumentException("Bad userinfo: " + proxyurl);
            }
            proxyuser = pieces[0];
            proxypwd = pieces[1];
        }
    }

    protected HTTPSession() throws HTTPException {
    }

    HTTPSession(String host, int port) throws HTTPException {
        this.init(new AuthScope(host, port, null, null), null);
    }

    HTTPSession(String uri) throws HTTPException {
        this.init(HTTPAuthUtil.uriToAuthScope(uri), uri);
    }

    HTTPSession(HttpHost httphost) throws HTTPException {
        this.init(HTTPAuthUtil.hostToAuthScope(httphost), null);
    }

    protected void init(AuthScope scope, String actualurl) throws HTTPException {
        assert (scope != null);
        this.sessionURI = actualurl != null ? actualurl : HTTPAuthUtil.authscopeToURI(scope).toString();
        this.scope = scope;
        this.scopeURI = HTTPAuthUtil.authscopeToURI(scope);
        this.cachevalid = false;
        this.sessioncontext.setCookieStore((CookieStore)new BasicCookieStore());
        this.sessioncontext.setAttribute("http.auth.auth-cache", (Object)new BasicAuthCache());
    }

    protected static void setInterceptors(HttpClientBuilder cb) {
        for (HttpRequestInterceptor hrq : reqintercepts) {
            cb.addInterceptorLast(hrq);
        }
        for (HttpResponseInterceptor hrs : rspintercepts) {
            cb.addInterceptorLast(hrs);
        }
        for (HttpRequestInterceptor hrq : dbgreq) {
            cb.addInterceptorFirst(hrq);
        }
        for (HttpResponseInterceptor hrs : dbgrsp) {
            cb.addInterceptorFirst(hrs);
        }
        cb.addInterceptorFirst(CEKILL);
    }

    public AuthScope getAuthScope() {
        return this.scope;
    }

    public String getSessionURI() {
        return this.sessionURI;
    }

    public String getSessionID() {
        String sid = null;
        String jsid = null;
        List cookies = this.sessioncontext.getCookieStore().getCookies();
        for (Cookie cookie : cookies) {
            if (cookie.getName().equalsIgnoreCase("sessionid")) {
                sid = cookie.getValue();
            }
            if (!cookie.getName().equalsIgnoreCase("jsessionid")) continue;
            jsid = cookie.getValue();
        }
        return sid == null ? jsid : sid;
    }

    public HTTPSession setUserAgent(String agent) {
        if (agent == null || agent.length() == 0) {
            throw new IllegalArgumentException("null argument");
        }
        this.localsettings.setParameter(USER_AGENT, agent);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setSoTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("setSoTimeout");
        }
        this.localsettings.setParameter(SO_TIMEOUT, timeout);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setConnectionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("setConnectionTImeout");
        }
        this.localsettings.setParameter(CONN_TIMEOUT, timeout);
        this.localsettings.setParameter(CONN_REQ_TIMEOUT, timeout);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setMaxRedirects(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setMaxRedirects");
        }
        this.localsettings.setParameter(MAX_REDIRECTS, n);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setFollowRedirects(boolean tf) {
        this.localsettings.setParameter(HANDLE_REDIRECTS, tf);
        this.cachevalid = false;
        return this;
    }

    public HTTPSession setUseSessions(boolean tf) {
        this.localsettings.setParameter(USESESSIONS, tf);
        this.cachevalid = false;
        return this;
    }

    public List<Cookie> getCookies() {
        if (this.sessioncontext == null) {
            return null;
        }
        List cookies = this.sessioncontext.getCookieStore().getCookies();
        return cookies;
    }

    public HTTPSession clearCookies() {
        BasicCookieStore cookies = (BasicCookieStore)this.sessioncontext.getCookieStore();
        if (cookies != null) {
            cookies.clear();
        }
        return this;
    }

    public HTTPSession clearCredentialsCache() {
        BasicAuthCache ac = (BasicAuthCache)this.sessioncontext.getAttribute("http.auth.auth-cache");
        if (ac != null) {
            ac.clear();
        }
        return this;
    }

    HttpClient getClient() {
        return this.cachedclient;
    }

    HttpClientContext getExecutionContext() {
        return this.sessioncontext;
    }

    public Object getSetting(String key) {
        return this.localsettings.get(key);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        while (this.methodList.size() > 0) {
            HTTPMethod m = this.methodList.get(0);
            m.close();
        }
        this.closed = true;
    }

    synchronized HTTPSession addMethod(HTTPMethod m) {
        if (!this.methodList.contains(m)) {
            this.methodList.add(m);
        }
        return this;
    }

    synchronized HTTPSession removeMethod(HTTPMethod m) {
        this.methodList.remove(m);
        return this;
    }

    public HTTPSession setCredentialsProvider(CredentialsProvider provider) throws HTTPException {
        this.setCredentialsProvider(provider, null);
        return this;
    }

    public HTTPSession setCredentialsProvider(CredentialsProvider provider, AuthScope scope) throws HTTPException {
        HTTPSession.mapcreds(provider, scope, this.localcreds);
        return this;
    }

    public HTTPSession setCredentials(Credentials creds) throws HTTPException {
        this.setCredentials(creds, null);
        return this;
    }

    public HTTPSession setCredentials(Credentials creds, AuthScope scope) throws HTTPException {
        assert (creds != null);
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        this.setCredentialsProvider((CredentialsProvider)provider, scope);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableHttpResponse execute(HTTPMethod method, URI methoduri, RequestBuilder rb) throws HTTPException {
        CloseableHttpResponse response;
        this.requestURI = methoduri;
        AuthScope methodscope = HTTPAuthUtil.uriToAuthScope(methoduri);
        AuthScope target = HTTPAuthUtil.authscopeUpgrade(this.scope, methodscope);
        HTTPSession hTTPSession = this;
        synchronized (hTTPSession) {
            Settings merged = HTTPUtil.merge(globalsettings, this.localsettings);
            if (!this.cachevalid) {
                RequestConfig.Builder rcb = RequestConfig.custom();
                this.cachedconfig = this.configureRequest(rcb, merged);
                HttpClientBuilder cb = HttpClients.custom();
                this.configClient(cb, merged);
                this.setAuthenticationAndProxy(cb);
                this.cachedclient = cb.build();
                rb.setConfig(this.cachedconfig);
                this.cachevalid = true;
            }
        }
        this.request = rb.build();
        try {
            HttpHost targethost = HTTPAuthUtil.authscopeToHost(target);
            response = this.cachedclient.execute(targethost, (HttpRequest)this.request, (HttpContext)this.sessioncontext);
        }
        catch (IOException ioe) {
            throw new HTTPException(ioe);
        }
        return response;
    }

    protected RequestConfig configureRequest(RequestConfig.Builder rcb, Settings settings) throws HTTPException {
        for (String key : settings.getKeys()) {
            boolean tf;
            Object value = settings.getParameter(key);
            boolean bl = tf = value instanceof Boolean ? (Boolean)value : false;
            if (key.equals(ALLOW_CIRCULAR_REDIRECTS)) {
                rcb.setCircularRedirectsAllowed(tf);
                continue;
            }
            if (key.equals(HANDLE_REDIRECTS)) {
                rcb.setRedirectsEnabled(tf);
                rcb.setRelativeRedirectsAllowed(tf);
                continue;
            }
            if (key.equals(MAX_REDIRECTS)) {
                rcb.setMaxRedirects(((Integer)value).intValue());
                continue;
            }
            if (key.equals(SO_TIMEOUT)) {
                rcb.setSocketTimeout(((Integer)value).intValue());
                continue;
            }
            if (key.equals(CONN_TIMEOUT)) {
                rcb.setConnectTimeout(((Integer)value).intValue());
                continue;
            }
            if (!key.equals(CONN_REQ_TIMEOUT)) continue;
            rcb.setConnectionRequestTimeout(((Integer)value).intValue());
        }
        RequestConfig cfg = rcb.build();
        return cfg;
    }

    protected void configClient(HttpClientBuilder cb, Settings settings) throws HTTPException {
        cb.useSystemProperties();
        String agent = (String)settings.get(USER_AGENT);
        if (agent != null) {
            cb.setUserAgent(agent);
        }
        HTTPSession.setInterceptors(cb);
        cb.setContentDecoderRegistry(contentDecoderMap);
    }

    protected synchronized void setAuthenticationAndProxy(HttpClientBuilder cb) throws HTTPException {
        cb.setSSLSocketFactory((LayeredConnectionSocketFactory)globalsslfactory);
        AuthScope bestMatch = HTTPAuthUtil.bestmatch(this.scope, this.localcreds.keySet());
        CredentialsProvider cp = null;
        if (bestMatch != null) {
            cp = this.localcreds.get(bestMatch);
        } else {
            bestMatch = HTTPAuthUtil.bestmatch(this.scope, globalcreds.keySet());
            if (bestMatch != null) {
                cp = globalcreds.get(bestMatch);
            }
        }
        UsernamePasswordCredentials proxycreds = null;
        AuthScope proxyscope = null;
        if (proxyuser != null && (httpproxy != null || httpsproxy != null)) {
            proxyscope = httpproxy != null ? HTTPAuthUtil.hostToAuthScope(httpproxy) : HTTPAuthUtil.hostToAuthScope(httpsproxy);
            proxycreds = new UsernamePasswordCredentials(proxyuser, proxypwd);
        }
        if (cp == null && proxycreds != null && proxyscope != null) {
            cp = new BasicCredentialsProvider();
            cp.setCredentials(proxyscope, (Credentials)proxycreds);
        } else if (cp != null && proxycreds != null && proxyscope != null) {
            cp.setCredentials(proxyscope, proxycreds);
        }
        if (cp != null) {
            this.sessioncontext.setCredentialsProvider(cp);
        }
    }

    static String getCanonicalURL(String legalurl) {
        if (legalurl == null) {
            return null;
        }
        int index = legalurl.indexOf(63);
        if (index >= 0) {
            legalurl = legalurl.substring(0, index);
        }
        return HTTPUtil.canonicalpath(legalurl);
    }

    static String getUrlAsString(String url) throws HTTPException {
        try (HTTPMethod m = HTTPFactory.Get(url);){
            int status = m.execute();
            String content = null;
            if (status == 200) {
                content = m.getResponseAsString();
            }
            String string = content;
            return string;
        }
    }

    static int putUrlAsString(String content, String url) throws HTTPException {
        int status = 0;
        try (HTTPMethod m = HTTPFactory.Put(url);){
            m.setRequestContent((HttpEntity)new StringEntity(content, ContentType.create((String)"application/text", (String)"UTF-8")));
            status = m.execute();
        }
        catch (UnsupportedCharsetException uce) {
            throw new HTTPException(uce);
        }
        return status;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String cleanproperty(String property) {
        String value = System.getProperty(property);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static void mapcreds(CredentialsProvider provider, AuthScope scope, Map<AuthScope, CredentialsProvider> authcreds) {
        assert (provider != null);
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        authcreds.put(scope, provider);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized int getMethodcount() {
        return this.methodList.size();
    }

    public RequestConfig getDebugConfig() {
        return this.cachevalid ? this.cachedconfig : null;
    }

    public Header[] getRequestHeaders() {
        if (!this.cachevalid) {
            return null;
        }
        Header[] hdrs = null;
        if (this.request != null) {
            hdrs = this.request.getAllHeaders();
        }
        return hdrs;
    }

    protected static synchronized void kill() {
        if (sessionList != null) {
            for (HTTPSession session : sessionList) {
                session.close();
            }
            sessionList.clear();
            connmgr.shutdown();
            connmgr = new PoolingHttpClientConnectionManager(sslregistry);
            HTTPSession.setGlobalThreadCount(50);
        }
    }

    protected static synchronized void track(HTTPSession session) {
        if (sessionList == null) {
            sessionList = new ArrayList<HTTPSession>();
        }
        sessionList.add(session);
    }

    public static synchronized void debugHeaders(boolean print) {
        HttpRequestInterceptor hr;
        int i;
        HTTPUtil.InterceptRequest rq = new HTTPUtil.InterceptRequest();
        HTTPUtil.InterceptResponse rs = new HTTPUtil.InterceptResponse();
        rq.setPrint(print);
        rs.setPrint(print);
        for (i = reqintercepts.size() - 1; i >= 0; --i) {
            hr = reqintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            reqintercepts.remove(i);
        }
        for (i = rspintercepts.size() - 1; i >= 0; --i) {
            hr = rspintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            rspintercepts.remove(i);
        }
        reqintercepts.add(rq);
        rspintercepts.add(rs);
    }

    public static void debugReset() {
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptCommon)) continue;
            ((HTTPUtil.InterceptCommon)hri).clear();
        }
    }

    public static HTTPUtil.InterceptRequest debugRequestInterceptor() {
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptRequest)) continue;
            return (HTTPUtil.InterceptRequest)hri;
        }
        return null;
    }

    public static HTTPUtil.InterceptResponse debugResponseInterceptor() {
        for (HttpResponseInterceptor hri : rspintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptResponse)) continue;
            return (HTTPUtil.InterceptResponse)hri;
        }
        return null;
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(AuthScope scope, CredentialsProvider provider) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(String url, CredentialsProvider provider) throws HTTPException {
        assert (url != null && provider != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        HTTPSession.setGlobalCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static void setGlobalCredentials(String url, Credentials creds) throws HTTPException {
        assert (url != null && creds != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(scope, creds);
        HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider, scope);
    }

    @Deprecated
    public void setCredentials(String url, Credentials creds) throws HTTPException {
        assert (creds != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        this.setCredentials(creds, scope);
    }

    @Deprecated
    public void setCredentialsProvider(String url, CredentialsProvider provider) throws HTTPException {
        assert (url != null && provider != null);
        AuthScope scope = HTTPAuthUtil.uriToAuthScope(url);
        this.setCredentialsProvider(provider, scope);
    }

    @Deprecated
    public void setCredentialsProvider(AuthScope scope, CredentialsProvider provider) throws HTTPException {
        this.setCredentialsProvider(provider, scope);
    }

    @Deprecated
    public static int getRetryCount() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void setGlobalCompression() {
        HTTPSession.setGlobalCompression("gzip,deflate");
    }

    @Deprecated
    public static void setGlobalProxy(String host, int port) {
        try {
            URL u = new URL("http", host, port, null);
            HTTPSession.setGlobalProxy(u.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    public void setProxy(String host, int port) {
        HTTPSession.setGlobalProxy(host, port);
    }

    @Deprecated
    public static void setGlobalCredentialsProvider(CredentialsProvider provider, String scheme) throws HTTPException {
        HTTPSession.setGlobalCredentialsProvider(provider);
    }

    @Deprecated
    public static void setRetryCount(int count) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void clearState() {
    }

    @Deprecated
    public String getSessionURL() {
        return this.getSessionURI();
    }

    static {
        reqintercepts = new ArrayList<HttpRequestInterceptor>();
        rspintercepts = new ArrayList<HttpResponseInterceptor>();
        dbgreq = new ArrayList<HttpRequestInterceptor>();
        dbgrsp = new ArrayList<HttpResponseInterceptor>();
        globalcreds = new HashMap<AuthScope, CredentialsProvider>();
        keystore = null;
        truststore = null;
        keypath = null;
        keypassword = null;
        trustpath = null;
        trustpassword = null;
        globalsslfactory = null;
        sslregistry = null;
        httpproxy = null;
        httpsproxy = null;
        proxyuser = null;
        proxypwd = null;
        globaldebugheaders = null;
        CEKILL = new HTTPUtil.ContentEncodingInterceptor();
        contentDecoderMap = new HashMap<String, InputStreamFactory>();
        contentDecoderMap.put("zip", new ZipStreamFactory());
        contentDecoderMap.put("gzip", new GZIPStreamFactory());
        globalsettings = new Settings();
        HTTPSession.setDefaults(globalsettings);
        HTTPSession.processDFlags();
        connmgr = new PoolingHttpClientConnectionManager(sslregistry);
        HTTPSession.setGlobalUserAgent(DFALTUSERAGENT);
        HTTPSession.setGlobalThreadCount(50);
        HTTPSession.setGlobalConnectionTimeout(60000);
        HTTPSession.setGlobalSoTimeout(300000);
        sessionList = null;
        TESTING = false;
    }

    static class GZIPStreamFactory
    implements InputStreamFactory {
        GZIPStreamFactory() {
        }

        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    }

    static class ZipStreamFactory
    implements InputStreamFactory {
        ZipStreamFactory() {
        }

        public InputStream create(InputStream instream) throws IOException {
            return new ZipInputStream(instream, HTTPUtil.UTF8);
        }
    }

    static class DeflateResponseInterceptor
    implements HttpResponseInterceptor {
        DeflateResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h : codecs = ceheader.getElements()) {
                    if (!h.getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static class GZIPResponseInterceptor
    implements HttpResponseInterceptor {
        GZIPResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h : codecs = ceheader.getElements()) {
                    if (!h.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Settings
    extends Hashtable<String, Object> {
        public Set<String> getKeys() {
            return this.keySet();
        }

        public Object getParameter(String param) {
            return super.get(param);
        }

        public long getIntParameter(String param) {
            return (Long)super.get(param);
        }

        public Settings setParameter(String param, Object value) {
            super.put(param, value);
            return this;
        }

        public Object removeParameter(String param) {
            return super.remove(param);
        }
    }

    static class LooseTrustStrategy
    extends TrustSelfSignedStrategy {
        LooseTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                if (super.isTrusted(chain, authType)) {
                    return true;
                }
                for (X509Certificate x5 : chain) {
                    try {
                        x5.checkValidity();
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException ce) {
                        return true;
                    }
                }
            }
            catch (CertificateException e) {
                return true;
            }
            return false;
        }
    }
}

